/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.mode.spi;

import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.protocol.bgp.mode.api.BestPathState;
import org.opendaylight.protocol.bgp.rib.spi.RouterId;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.OriginatorId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.BgpOrigin;
import org.opendaylight.yangtools.yang.common.Uint32;

public class AbstractBestPathSelector {
    private final long ourAs;
    protected RouterId bestOriginatorId = null;
    protected BestPathState bestState = null;

    protected AbstractBestPathSelector(long ourAs) {
        this.ourAs = ourAs;
    }

    protected RouterId replaceOriginator(RouterId routerId, OriginatorId originatorId) {
        return originatorId != null ? RouterId.forAddress((Ipv4Address)originatorId.getOriginator()) : routerId;
    }

    protected boolean isExistingPathBetter(@NonNull BestPathState state) {
        long newAs;
        boolean stateDepref = state.isDepreferenced();
        if (this.bestState.isDepreferenced() != stateDepref) {
            return stateDepref;
        }
        Uint32 bestLocal = this.bestState.getLocalPref();
        Uint32 stateLocal = state.getLocalPref();
        if (stateLocal != null) {
            if (bestLocal == null) {
                return true;
            }
            int cmp = stateLocal.compareTo(bestLocal);
            if (cmp != 0) {
                return cmp < 0;
            }
        } else if (bestLocal != null) {
            return false;
        }
        if (this.bestState.getAsPathLength() != state.getAsPathLength()) {
            return this.bestState.getAsPathLength() < state.getAsPathLength();
        }
        if (!this.bestState.getOrigin().equals((Object)state.getOrigin())) {
            BgpOrigin bo = this.bestState.getOrigin();
            BgpOrigin no = state.getOrigin();
            return no.ordinal() > bo.ordinal();
        }
        long bestAs = this.bestState.getPeerAs();
        if (bestAs == (newAs = state.getPeerAs())) {
            Boolean cmp = AbstractBestPathSelector.firstLower(this.bestState.getMultiExitDisc(), state.getMultiExitDisc());
            if (cmp != null) {
                return cmp;
            }
        } else if (this.ourAs != bestAs && this.ourAs == newAs) {
            return true;
        }
        return true;
    }

    private static Boolean firstLower(long first, long second) {
        return first < second ? Boolean.TRUE : (first == second ? null : Boolean.FALSE);
    }
}

