/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.mode.impl;

import org.junit.Before;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.opendaylight.mdsal.binding.dom.adapter.test.AbstractConcurrentDataBrokerTest;
import org.opendaylight.protocol.bgp.rib.spi.BGPPeerTracker;
import org.opendaylight.protocol.bgp.rib.spi.Peer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.PeerId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.PeerRole;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.rib.TablesKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.Ipv4AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.UnicastSubsequentAddressFamily;

public class BGPPeerTrackerMock
extends AbstractConcurrentDataBrokerTest {
    protected static final PeerId PEER_ID = new PeerId("bgp://42.42.42.42");
    protected static final PeerId PEER_ID2 = new PeerId("bgp://43.43.43.43");
    protected static final TablesKey TABLES_KEY = new TablesKey(Ipv4AddressFamily.class, UnicastSubsequentAddressFamily.class);
    @Mock
    protected BGPPeerTracker peerTracker;
    @Mock
    protected Peer peerMock;
    @Mock
    protected Peer peerMock2;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)((Object)this));
        this.mockPeerTracker();
    }

    private void mockPeerTracker() {
        PeerId pId = new PeerId("bgp://0.0.0.1");
        ((BGPPeerTracker)Mockito.doReturn((Object)this.peerMock).when((Object)this.peerTracker)).getPeer((PeerId)ArgumentMatchers.eq((Object)pId));
        ((BGPPeerTracker)Mockito.doReturn((Object)this.peerMock).when((Object)this.peerTracker)).getPeer((PeerId)ArgumentMatchers.eq((Object)PEER_ID));
        ((Peer)Mockito.doReturn((Object)true).when((Object)this.peerMock)).supportsTable((TablesKey)Mockito.eq((Object)TABLES_KEY));
        ((Peer)Mockito.doReturn((Object)PeerRole.Ibgp).when((Object)this.peerMock)).getRole();
        ((BGPPeerTracker)Mockito.doReturn((Object)this.peerMock2).when((Object)this.peerTracker)).getPeer((PeerId)ArgumentMatchers.eq((Object)PEER_ID2));
        ((Peer)Mockito.doReturn((Object)false).when((Object)this.peerMock2)).supportsTable((TablesKey)Mockito.eq((Object)TABLES_KEY));
    }
}

