/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.mode.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import org.opendaylight.yangtools.concepts.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public abstract class AbstractOffsetMap<K extends Immutable & Comparable<K>, T extends AbstractOffsetMap<K, T>> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractOffsetMap.class);
    private static final String INVALIDOFFSET = "Invalid offset %s for %s router IDs";
    private final K[] keys;

    protected AbstractOffsetMap(K[] emptyKeys, Comparator<K> comparator, ImmutableSet<K> routerIds) {
        Immutable[] array = (Immutable[])routerIds.toArray((Object[])emptyKeys);
        Arrays.sort(array, comparator);
        this.keys = array;
    }

    public final K getKey(int offset) {
        return this.keys[offset];
    }

    public final int offsetOf(K key) {
        return Arrays.binarySearch(this.keys, key, this.comparator());
    }

    public final boolean isEmpty() {
        return this.keys.length == 0;
    }

    public final int size() {
        return this.keys.length;
    }

    public final T with(K key) {
        ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)(this.size() + 1));
        builder.add((Object[])this.keys);
        builder.add(key);
        return this.instanceForKeys(builder.build());
    }

    public final T without(K key) {
        ImmutableSet set;
        int index = this.indexOf(key);
        if (index < 0) {
            LOG.trace("Router key {} not found", key);
            set = ImmutableSet.of();
        } else {
            set = ImmutableSet.copyOf((Object[])this.removeValue(this.keys, index, this.emptyKeys()));
        }
        return this.instanceForKeys(set);
    }

    public final <C> C getValue(C[] array, int offset) {
        this.checkAccessOffest(offset);
        return array[offset];
    }

    public final <C> void setValue(C[] array, int offset, C value) {
        this.checkAccessOffest(offset);
        array[offset] = value;
    }

    public final <C> C[] expand(T oldOffsets, C[] oldArray, int offset) {
        Object[] ret = (Object[])Array.newInstance(oldArray.getClass().getComponentType(), this.keys.length);
        System.arraycopy(oldArray, 0, ret, 0, offset);
        System.arraycopy(oldArray, offset, ret, offset + 1, ((AbstractOffsetMap)oldOffsets).size() - offset);
        return ret;
    }

    public final <C> C[] removeValue(C[] oldArray, int offset, C[] emptyArray) {
        AbstractOffsetMap.checkNegativeOffset(offset);
        int length = oldArray.length;
        Preconditions.checkArgument((offset < this.keys.length ? 1 : 0) != 0, (String)INVALIDOFFSET, (int)offset, (int)length);
        int newLength = length - 1;
        if (newLength == 0) {
            Preconditions.checkArgument((emptyArray.length == 0 ? 1 : 0) != 0);
            return emptyArray;
        }
        Object[] ret = (Object[])Array.newInstance(oldArray.getClass().getComponentType(), newLength);
        System.arraycopy(oldArray, 0, ret, 0, offset);
        if (offset < newLength) {
            System.arraycopy(oldArray, offset + 1, ret, offset, newLength - offset);
        }
        return ret;
    }

    protected abstract Comparator<K> comparator();

    protected abstract K[] emptyKeys();

    protected abstract T instanceForKeys(ImmutableSet<K> var1);

    private int indexOf(K key) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!key.equals(this.keys[i])) continue;
            return i;
        }
        return -1;
    }

    private void checkAccessOffest(int offset) {
        AbstractOffsetMap.checkNegativeOffset(offset);
        Preconditions.checkArgument((offset < this.keys.length ? 1 : 0) != 0, (String)INVALIDOFFSET, (int)offset, (int)this.keys.length);
    }

    private static void checkNegativeOffset(int offset) {
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (String)"Invalid negative offset %s", (int)offset);
    }
}

