/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.mode.impl;

import java.util.List;
import java.util.Objects;
import org.opendaylight.protocol.bgp.rib.spi.Peer;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryExportParameters;
import org.opendaylight.protocol.bgp.rib.spi.policy.RTCCache;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.PeerId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.PeerRole;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.Route;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.ClusterIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.RouteTarget;

public final class BGPRouteEntryExportParametersImpl
implements BGPRouteEntryExportParameters {
    private final Peer fromPeer;
    private final Peer toPeer;
    private final String routeKey;
    private final RTCCache rtCache;

    public BGPRouteEntryExportParametersImpl(Peer fromPeer, Peer toPeer, String routeKey, RTCCache rtCache) {
        this.fromPeer = Objects.requireNonNull(fromPeer);
        this.toPeer = Objects.requireNonNull(toPeer);
        this.routeKey = routeKey;
        this.rtCache = rtCache;
    }

    public PeerRole getFromPeerRole() {
        return this.fromPeer.getRole();
    }

    public PeerId getFromPeerId() {
        return this.fromPeer.getPeerId();
    }

    public ClusterIdentifier getFromClusterId() {
        return this.fromPeer.getClusterId();
    }

    public AsNumber getFromPeerLocalAs() {
        return this.fromPeer.getLocalAs();
    }

    public PeerRole getToPeerRole() {
        return this.toPeer.getRole();
    }

    public AsNumber getToPeerLocalAs() {
        return this.toPeer.getLocalAs();
    }

    public String getRouteKey() {
        return this.routeKey;
    }

    public PeerId getToPeerId() {
        return this.toPeer.getPeerId();
    }

    public List<RouteTarget> getMemberships() {
        return this.toPeer.getMemberships();
    }

    public List<Route> getClientRouteTargetContrainCache() {
        return this.rtCache.getClientRouteTargetContrainCache();
    }
}

