/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.mode.impl.add;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.protocol.bgp.rib.spi.RouterId;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.Uint32;

@NonNullByDefault
final class RouteKey
implements Comparable<RouteKey>,
Immutable {
    private final RouterId routerId;
    private final long remotePathId;

    RouteKey(RouterId routerId, Uint32 remotePathId) {
        this.routerId = Objects.requireNonNull(routerId);
        this.remotePathId = remotePathId.toJava();
    }

    RouterId getRouterId() {
        return this.routerId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Long.hashCode(this.remotePathId);
        result = 31 * result + this.routerId.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RouteKey)) {
            return false;
        }
        RouteKey other = (RouteKey)obj;
        return this.remotePathId == other.remotePathId && this.routerId.equals((Object)other.routerId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("externalPathId", this.remotePathId).add("routerId", (Object)this.routerId).toString();
    }

    @Override
    public int compareTo(RouteKey otherRouteKey) {
        int cmp = this.routerId.compareTo(otherRouteKey.routerId);
        return cmp != 0 ? cmp : Long.compare(this.remotePathId, otherRouteKey.remotePathId);
    }
}

