/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.mode.impl.add;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import org.opendaylight.protocol.bgp.mode.impl.AbstractOffsetMap;
import org.opendaylight.protocol.bgp.mode.impl.add.RouteKey;
import org.opendaylight.yangtools.concepts.Immutable;

final class RouteKeyOffsets
extends AbstractOffsetMap<RouteKey, RouteKeyOffsets> {
    private static final LoadingCache<ImmutableSet<RouteKey>, RouteKeyOffsets> OFFSETMAPS = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<ImmutableSet<RouteKey>, RouteKeyOffsets>(){

        public RouteKeyOffsets load(ImmutableSet<RouteKey> key) {
            return new RouteKeyOffsets(key);
        }
    });
    private static final Comparator<RouteKey> COMPARATOR = RouteKey::compareTo;
    private static final RouteKey[] EMPTY_KEYS = new RouteKey[0];
    static final RouteKeyOffsets EMPTY = new RouteKeyOffsets((ImmutableSet<RouteKey>)ImmutableSet.of());

    private RouteKeyOffsets(ImmutableSet<RouteKey> routeKeys) {
        super((Immutable[])EMPTY_KEYS, COMPARATOR, routeKeys);
    }

    @Override
    protected Comparator<RouteKey> comparator() {
        return COMPARATOR;
    }

    protected RouteKey[] emptyKeys() {
        return EMPTY_KEYS;
    }

    @Override
    protected RouteKeyOffsets instanceForKeys(ImmutableSet<RouteKey> newKeys) {
        return (RouteKeyOffsets)OFFSETMAPS.getUnchecked(newKeys);
    }
}

