/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.mode.impl.add.all.paths;

import com.google.common.collect.ImmutableList;
import org.opendaylight.protocol.bgp.mode.impl.add.AddPathAbstractRouteEntry;
import org.opendaylight.protocol.bgp.mode.impl.add.AddPathBestPath;
import org.opendaylight.protocol.bgp.mode.impl.add.AddPathSelector;
import org.opendaylight.protocol.bgp.rib.spi.RIBSupport;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.rib.tables.Routes;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AllPathsRouteEntry<C extends Routes & DataObject, S extends ChildOf<? super C>>
extends AddPathAbstractRouteEntry<C, S> {
    private static final Logger LOG = LoggerFactory.getLogger(AllPathsRouteEntry.class);

    AllPathsRouteEntry() {
    }

    @Override
    protected ImmutableList<AddPathBestPath> selectBest(RIBSupport<C, S> ribSupport, long localAs, int size) {
        int offset;
        AddPathSelector selector = new AddPathSelector(localAs);
        for (int offset2 = 0; offset2 < size; ++offset2) {
            this.processOffset(ribSupport, selector, offset2);
        }
        AddPathBestPath newBest = selector.result();
        LOG.trace("Best path selected {}", (Object)newBest);
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)size);
        builder.add((Object)newBest);
        for (offset = 0; offset < newBest.getOffset(); ++offset) {
            builder.add((Object)this.bestPathAt(ribSupport, offset));
        }
        for (offset = newBest.getOffset() + 1; offset < size; ++offset) {
            builder.add((Object)this.bestPathAt(ribSupport, offset));
        }
        return builder.build();
    }
}

