/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.mode.impl.add.n.paths;

import com.google.common.collect.ImmutableList;
import org.opendaylight.protocol.bgp.mode.impl.add.AddPathAbstractRouteEntry;
import org.opendaylight.protocol.bgp.mode.impl.add.AddPathBestPath;
import org.opendaylight.protocol.bgp.mode.impl.add.AddPathSelector;
import org.opendaylight.protocol.bgp.rib.spi.RIBSupport;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.rib.tables.Routes;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class NPathsRouteEntry<C extends Routes & DataObject, S extends ChildOf<? super C>>
extends AddPathAbstractRouteEntry<C, S> {
    private static final Logger LOG = LoggerFactory.getLogger(NPathsRouteEntry.class);
    private final int npaths;

    NPathsRouteEntry(int npaths) {
        this.npaths = npaths;
    }

    @Override
    protected ImmutableList<AddPathBestPath> selectBest(RIBSupport<C, S> ribSupport, long localAs, int size) {
        int limit = Math.min(this.npaths, size);
        switch (limit) {
            case 0: {
                return ImmutableList.of();
            }
            case 1: {
                return ImmutableList.of((Object)this.bestPathAt(ribSupport, 0));
            }
        }
        return this.selectBest(ribSupport, localAs, size, limit);
    }

    private ImmutableList<AddPathBestPath> selectBest(RIBSupport<C, S> ribSupport, long localAs, int size, int limit) {
        boolean[] offsets = new boolean[size];
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)limit);
        for (int search = 0; search < limit; ++search) {
            AddPathSelector selector = new AddPathSelector(localAs);
            for (int offset = 0; offset < size; ++offset) {
                if (offsets[offset]) continue;
                this.processOffset(ribSupport, selector, offset);
            }
            AddPathBestPath result = selector.result();
            LOG.trace("Path {} selected {}", (Object)search, (Object)result);
            builder.add((Object)result);
            offsets[result.getOffset()] = true;
        }
        return builder.build();
    }
}

