/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.mode.impl.base;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.opendaylight.protocol.bgp.mode.api.RouteEntry;
import org.opendaylight.protocol.bgp.mode.impl.base.BaseBestPath;
import org.opendaylight.protocol.bgp.mode.impl.base.BasePathSelector;
import org.opendaylight.protocol.bgp.mode.impl.base.RouterIdOffsets;
import org.opendaylight.protocol.bgp.rib.spi.RIBSupport;
import org.opendaylight.protocol.bgp.rib.spi.RouterId;
import org.opendaylight.protocol.bgp.rib.spi.entry.ActualBestPathRoutes;
import org.opendaylight.protocol.bgp.rib.spi.entry.AdvertizedRoute;
import org.opendaylight.protocol.bgp.rib.spi.entry.RouteEntryInfo;
import org.opendaylight.protocol.bgp.rib.spi.entry.StaleBestPathRoute;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.rib.tables.Routes;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BaseRouteEntry<C extends Routes & DataObject, S extends ChildOf<? super C>>
implements RouteEntry<C, S> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseRouteEntry.class);
    private static final MapEntryNode[] EMPTY_VALUES = new MapEntryNode[0];
    private RouterIdOffsets offsets = RouterIdOffsets.EMPTY;
    private MapEntryNode[] values = EMPTY_VALUES;
    private BaseBestPath bestPath;
    private BaseBestPath removedBestPath;

    BaseRouteEntry() {
    }

    @Override
    public boolean removeRoute(RouterId routerId, Uint32 remotePathId) {
        int offset = this.offsets.offsetOf(routerId);
        this.values = this.offsets.removeValue(this.values, offset, EMPTY_VALUES);
        this.offsets = (RouterIdOffsets)this.offsets.without(routerId);
        return this.offsets.isEmpty();
    }

    private MapEntryNode createRoute(RIBSupport<C, S> ribSup, String routeKey) {
        MapEntryNode route = this.offsets.getValue(this.values, this.offsets.offsetOf(this.bestPath.getRouterId()));
        return ribSup.createRoute(route, ribSup.createRouteListArgument(routeKey), this.bestPath.getAttributes());
    }

    @Override
    public boolean selectBest(RIBSupport<C, S> ribSupport, long localAs) {
        boolean modified;
        BasePathSelector selector = new BasePathSelector(localAs);
        for (int i = 0; i < this.offsets.size(); ++i) {
            RouterId routerId = (RouterId)this.offsets.getKey(i);
            ContainerNode attributes = ribSupport.extractAttributes(this.offsets.getValue(this.values, i));
            LOG.trace("Processing router id {} attributes {}", (Object)routerId, (Object)attributes);
            selector.processPath(routerId, attributes);
        }
        BaseBestPath newBestPath = selector.result();
        boolean bl = modified = newBestPath == null || !newBestPath.equals(this.bestPath);
        if (modified) {
            if (this.offsets.isEmpty()) {
                this.removedBestPath = this.bestPath;
            }
            LOG.trace("Previous best {}, current best {}", (Object)this.bestPath, (Object)newBestPath);
            this.bestPath = newBestPath;
        }
        return modified;
    }

    @Override
    public int addRoute(RouterId routerId, Uint32 remotePathId, MapEntryNode route) {
        int offset = this.offsets.offsetOf(routerId);
        if (offset < 0) {
            RouterIdOffsets newOffsets = (RouterIdOffsets)this.offsets.with(routerId);
            offset = newOffsets.offsetOf(routerId);
            this.values = newOffsets.expand(this.offsets, this.values, offset);
            this.offsets = newOffsets;
        }
        this.offsets.setValue(this.values, offset, route);
        LOG.trace("Added route {} from {}", (Object)route, (Object)routerId);
        return offset;
    }

    @Override
    public Optional<StaleBestPathRoute> removeStalePaths(RIBSupport<C, S> ribSupport, String routeKey) {
        if (this.removedBestPath == null) {
            return Optional.empty();
        }
        this.removedBestPath = null;
        return Optional.of(new Stale(ribSupport.createRouteListArgument(routeKey)));
    }

    @Override
    public List<AdvertizedRoute<C, S>> newBestPaths(RIBSupport<C, S> ribSupport, String routeKey) {
        if (this.bestPath == null) {
            return Collections.emptyList();
        }
        MapEntryNode route = this.createRoute(ribSupport, routeKey);
        AdvertizedRoute adv = new AdvertizedRoute(ribSupport, route, this.bestPath.getAttributes(), this.bestPath.getPeerId(), this.bestPath.isDepreferenced());
        LOG.trace("Selected best route {}", (Object)route);
        return Collections.singletonList(adv);
    }

    @Override
    public List<ActualBestPathRoutes<C, S>> actualBestPaths(RIBSupport<C, S> ribSupport, RouteEntryInfo entryInfo) {
        if (this.bestPath == null) {
            return Collections.emptyList();
        }
        MapEntryNode route = this.createRoute(ribSupport, entryInfo.getRouteKey());
        return Collections.singletonList(new ActualBestPathRoutes(ribSupport, route, this.bestPath.getPeerId(), this.bestPath.getAttributes(), this.bestPath.isDepreferenced()));
    }

    private static final class Stale
    extends StaleBestPathRoute {
        Stale(YangInstanceIdentifier.NodeIdentifierWithPredicates nonAddPathRouteKeyIdentifier) {
            super(nonAddPathRouteKeyIdentifier);
        }

        public List<YangInstanceIdentifier.NodeIdentifierWithPredicates> getStaleRouteKeyIdentifiers() {
            return Collections.singletonList(this.getNonAddPathRouteKeyIdentifier());
        }

        public List<YangInstanceIdentifier.NodeIdentifierWithPredicates> getAddPathRouteKeyIdentifiers() {
            return Collections.emptyList();
        }

        public boolean isNonAddPathBestPathNew() {
            return true;
        }
    }
}

