/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.mode.impl.base;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import org.opendaylight.protocol.bgp.mode.impl.AbstractOffsetMap;
import org.opendaylight.protocol.bgp.rib.spi.RouterId;
import org.opendaylight.yangtools.concepts.Immutable;

final class RouterIdOffsets
extends AbstractOffsetMap<RouterId, RouterIdOffsets> {
    private static final LoadingCache<ImmutableSet<RouterId>, RouterIdOffsets> OFFSETMAPS = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<ImmutableSet<RouterId>, RouterIdOffsets>(){

        public RouterIdOffsets load(ImmutableSet<RouterId> key) {
            return new RouterIdOffsets(key);
        }
    });
    private static final Comparator<RouterId> COMPARATOR = RouterId::compareTo;
    private static final RouterId[] EMPTY_KEYS = new RouterId[0];
    static final RouterIdOffsets EMPTY = new RouterIdOffsets((ImmutableSet<RouterId>)ImmutableSet.of());

    RouterIdOffsets(ImmutableSet<RouterId> routerIds) {
        super((Immutable[])EMPTY_KEYS, COMPARATOR, routerIds);
    }

    @Override
    protected Comparator<RouterId> comparator() {
        return COMPARATOR;
    }

    protected RouterId[] emptyKeys() {
        return EMPTY_KEYS;
    }

    @Override
    protected RouterIdOffsets instanceForKeys(ImmutableSet<RouterId> newKeys) {
        return (RouterIdOffsets)OFFSETMAPS.getUnchecked(newKeys);
    }
}

