/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.mode.impl.base;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.protocol.bgp.mode.impl.base.BaseBestPath;
import org.opendaylight.protocol.bgp.mode.impl.base.BasePathSelector;
import org.opendaylight.protocol.bgp.mode.impl.base.BasePathSelectorTest;
import org.opendaylight.protocol.bgp.parser.spi.PathIdUtil;
import org.opendaylight.protocol.bgp.rib.spi.RouterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.PeerId;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;

public class BaseBestPathTest {
    private static final RouterId ROUTER_ID = RouterId.forAddress((String)"127.0.0.1");
    private static final PeerId PEER_ID = new PeerId("bgp://127.0.0.1");
    private BaseBestPath baseBestPath;
    private BaseBestPath baseBestPathCopy;

    @Before
    public void setUp() {
        BasePathSelector selector = new BasePathSelector(20L);
        selector.processPath(BasePathSelectorTest.ROUTER_ID2, (ContainerNode)BasePathSelectorTest.createStateFromPrefMedOriginASPath().build());
        this.baseBestPath = selector.result();
        this.baseBestPathCopy = selector.result();
    }

    @Test
    public void testGetRouterId() {
        Assert.assertEquals((Object)ROUTER_ID, (Object)this.baseBestPath.getRouterId());
    }

    @Test
    public void testGetPeerId() {
        Assert.assertEquals((Object)PEER_ID, (Object)this.baseBestPath.getPeerId());
    }

    @Test
    public void testGetPathId() {
        Assert.assertEquals((long)PathIdUtil.NON_PATH_ID_VALUE.toJava(), (long)this.baseBestPath.getPathId());
    }

    @Test
    public void testHashCodeAndEqual() {
        Assert.assertTrue((this.baseBestPath.equals((Object)this.baseBestPathCopy) && this.baseBestPathCopy.equals((Object)this.baseBestPath) ? 1 : 0) != 0);
        Assert.assertEquals((long)this.baseBestPath.hashCode(), (long)this.baseBestPathCopy.hashCode());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)this.baseBestPath.toString(), (Object)this.baseBestPathCopy.toString());
    }
}

