/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.mode.impl.base;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bgp.mode.api.BestPathState;
import org.opendaylight.protocol.bgp.mode.impl.BestPathStateImpl;
import org.opendaylight.protocol.bgp.mode.impl.base.BaseBestPath;
import org.opendaylight.protocol.bgp.mode.impl.base.BasePathSelector;
import org.opendaylight.protocol.bgp.rib.spi.RouterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.AsPath;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.LocalPref;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.MultiExitDisc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.Origin;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.as.path.Segments;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.PeerId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.BgpOrigin;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.builder.DataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;

public class BasePathSelectorTest {
    static final RouterId ROUTER_ID2 = RouterId.forPeerId((PeerId)new PeerId("bgp://127.0.0.1"));
    private static final QName AS_SEQUENCE = QName.create((QName)Segments.QNAME, (String)"as-sequence");
    private static final List<Uint32> SEQ_SEGMENT = List.of(Uint32.ONE, Uint32.TWO, Uint32.valueOf((int)3));
    private static final List<Uint32> SEQ_SEGMENT2 = List.of(Uint32.valueOf((int)20), Uint32.TWO, Uint32.valueOf((int)3));
    private static final RouterId ROUTER_ID = RouterId.forAddress((String)"127.0.0.1");
    private static final RouterId ROUTER_ID3 = RouterId.forPeerId((PeerId)new PeerId("bgp://127.0.0.2"));
    private final BasePathSelector selector = new BasePathSelector(20L);
    private final BestPathStateImpl state = new BestPathStateImpl((ContainerNode)BasePathSelectorTest.createStateFromPrefMedOriginASPath().build());
    private final BaseBestPath originBestPath = new BaseBestPath(ROUTER_ID, (BestPathState)this.state);

    private static ContainerNode createStateFromPrefMedOrigin() {
        return (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(Attributes.QNAME)).withChild((DataContainerChild)BasePathSelectorTest.lowerLocalPref()).withChild((DataContainerChild)BasePathSelectorTest.lowerMultiExitDisc()).withChild((DataContainerChild)BasePathSelectorTest.igpOrigin()).build();
    }

    protected static DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifier, ContainerNode> createStateFromPrefMedOriginASPath() {
        return Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(Attributes.QNAME)).withChild((DataContainerChild)BasePathSelectorTest.higherLocalPref()).withChild((DataContainerChild)BasePathSelectorTest.higherMultiExitDisc()).withChild((DataContainerChild)BasePathSelectorTest.egpOrigin()).withChild((DataContainerChild)BasePathSelectorTest.asPath(SEQ_SEGMENT));
    }

    private static ContainerNode lowerLocalPref() {
        return BasePathSelectorTest.localPref(Uint32.valueOf((int)123));
    }

    private static ContainerNode higherLocalPref() {
        return BasePathSelectorTest.localPref(Uint32.valueOf((int)321));
    }

    private static ContainerNode localPref(Uint32 pref) {
        return (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(LocalPref.QNAME)).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)QName.create((QName)LocalPref.QNAME, (String)"pref"), (Object)pref)).build();
    }

    private static ContainerNode lowerMultiExitDisc() {
        return BasePathSelectorTest.multiExitDisc(Uint32.valueOf((int)1234));
    }

    private static ContainerNode higherMultiExitDisc() {
        return BasePathSelectorTest.multiExitDisc(Uint32.valueOf((int)4321));
    }

    private static ContainerNode multiExitDisc(Uint32 med) {
        return (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(MultiExitDisc.QNAME)).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)QName.create((QName)MultiExitDisc.QNAME, (String)"med"), (Object)med)).build();
    }

    private static ContainerNode egpOrigin() {
        return BasePathSelectorTest.origin(BgpOrigin.Egp);
    }

    private static ContainerNode igpOrigin() {
        return BasePathSelectorTest.origin(BgpOrigin.Igp);
    }

    private static ContainerNode origin(BgpOrigin value) {
        return (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(Origin.QNAME)).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)QName.create((QName)Origin.QNAME, (String)"value"), (Object)value.getName())).build();
    }

    private static ContainerNode asPath(List<Uint32> segment) {
        return (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(AsPath.QNAME)).withChild((DataContainerChild)Builders.unkeyedListBuilder().withNodeIdentifier(new YangInstanceIdentifier.NodeIdentifier(Segments.QNAME)).withChild((NormalizedNode)((UnkeyedListEntryNode)Builders.unkeyedListEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(Segments.QNAME)).withChild((DataContainerChild)Builders.orderedLeafSetBuilder().withNodeIdentifier(new YangInstanceIdentifier.NodeIdentifier(AS_SEQUENCE)).withValue((Collection)Lists.transform(segment, asn -> (LeafSetEntryNode)Builders.leafSetEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeWithValue(AS_SEQUENCE, asn)).withValue(asn).build())).build()).build())).build()).build();
    }

    @Test
    public void testBestPathWithHigherLocalPref() {
        this.selector.processPath(ROUTER_ID2, BasePathSelectorTest.createStateFromPrefMedOrigin());
        BaseBestPath processedPath = this.selector.result();
        Assert.assertEquals((Object)Uint32.valueOf((int)123), (Object)processedPath.getState().getLocalPref());
        this.selector.processPath(ROUTER_ID2, (ContainerNode)BasePathSelectorTest.createStateFromPrefMedOriginASPath().build());
        processedPath = this.selector.result();
        Assert.assertEquals((Object)Uint32.valueOf((int)321), (Object)processedPath.getState().getLocalPref());
        this.selector.processPath(ROUTER_ID2, (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(Attributes.QNAME)).withChild((DataContainerChild)BasePathSelectorTest.lowerLocalPref()).build());
        processedPath = this.selector.result();
        Assert.assertEquals((Object)Uint32.valueOf((int)321), (Object)processedPath.getState().getLocalPref());
    }

    @Test
    public void testBestPathForEquality() {
        this.selector.processPath(ROUTER_ID2, (ContainerNode)BasePathSelectorTest.createStateFromPrefMedOriginASPath().build());
        BaseBestPath processedPath = this.selector.result();
        Assert.assertEquals((Object)this.originBestPath.getPeerId(), (Object)processedPath.getPeerId());
        Assert.assertEquals((Object)this.originBestPath.getState().getLocalPref(), (Object)processedPath.getState().getLocalPref());
        Assert.assertEquals((long)this.originBestPath.getState().getMultiExitDisc(), (long)processedPath.getState().getMultiExitDisc());
        Assert.assertEquals((Object)this.originBestPath.getState().getOrigin(), (Object)processedPath.getState().getOrigin());
        Assert.assertEquals((long)this.originBestPath.getState().getPeerAs(), (long)processedPath.getState().getPeerAs());
        Assert.assertEquals((long)this.originBestPath.getState().getAsPathLength(), (long)processedPath.getState().getAsPathLength());
    }

    @Test
    public void testBestPathSelectionOptions() {
        DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifier, ContainerNode> dataContBuilder = BasePathSelectorTest.createStateFromPrefMedOriginASPath();
        this.selector.processPath(ROUTER_ID2, (ContainerNode)dataContBuilder.build());
        BaseBestPath processedPath = this.selector.result();
        Assert.assertEquals((Object)BgpOrigin.Egp, (Object)processedPath.getState().getOrigin());
        this.selector.processPath(ROUTER_ID2, (ContainerNode)dataContBuilder.withChild((DataContainerChild)BasePathSelectorTest.igpOrigin()).build());
        processedPath = this.selector.result();
        Assert.assertEquals((Object)BgpOrigin.Igp, (Object)processedPath.getState().getOrigin());
        this.selector.processPath(ROUTER_ID2, (ContainerNode)dataContBuilder.withChild((DataContainerChild)BasePathSelectorTest.egpOrigin()).build());
        processedPath = this.selector.result();
        Assert.assertEquals((Object)BgpOrigin.Igp, (Object)processedPath.getState().getOrigin());
        Assert.assertEquals((long)4321L, (long)processedPath.getState().getMultiExitDisc());
        this.selector.processPath(ROUTER_ID2, (ContainerNode)dataContBuilder.withChild((DataContainerChild)BasePathSelectorTest.igpOrigin()).withChild((DataContainerChild)BasePathSelectorTest.lowerMultiExitDisc()).build());
        processedPath = this.selector.result();
        Assert.assertEquals((long)1234L, (long)processedPath.getState().getMultiExitDisc());
        this.selector.processPath(ROUTER_ID2, (ContainerNode)dataContBuilder.withChild((DataContainerChild)BasePathSelectorTest.higherMultiExitDisc()).build());
        processedPath = this.selector.result();
        Assert.assertEquals((long)1234L, (long)processedPath.getState().getMultiExitDisc());
        Assert.assertEquals((long)1L, (long)processedPath.getState().getPeerAs());
        Assert.assertEquals((long)3L, (long)processedPath.getState().getAsPathLength());
        this.selector.processPath(ROUTER_ID2, (ContainerNode)dataContBuilder.withChild((DataContainerChild)BasePathSelectorTest.lowerMultiExitDisc()).withChild((DataContainerChild)BasePathSelectorTest.asPath(SEQ_SEGMENT2)).build());
        processedPath = this.selector.result();
        Assert.assertEquals((long)1L, (long)processedPath.getState().getPeerAs());
        Assert.assertEquals((long)3L, (long)processedPath.getState().getAsPathLength());
    }

    @Test
    public void testBestPathForNonEquality() {
        this.selector.processPath(ROUTER_ID3, BasePathSelectorTest.createStateFromPrefMedOrigin());
        BaseBestPath processedPath = this.selector.result();
        Assert.assertNotEquals((Object)this.originBestPath.getPeerId(), (Object)processedPath.getPeerId());
        Assert.assertNotEquals((Object)this.originBestPath.getState().getLocalPref(), (Object)processedPath.getState().getLocalPref());
        Assert.assertNotEquals((long)this.originBestPath.getState().getMultiExitDisc(), (long)processedPath.getState().getMultiExitDisc());
        Assert.assertNotEquals((Object)this.originBestPath.getState().getOrigin(), (Object)processedPath.getState().getOrigin());
        Assert.assertNotEquals((long)this.originBestPath.getState().getPeerAs(), (long)processedPath.getState().getPeerAs());
        Assert.assertNotEquals((long)this.originBestPath.getState().getAsPathLength(), (long)processedPath.getState().getAsPathLength());
    }

    @Test
    public void testBgpOrigin() {
        this.selector.processPath(ROUTER_ID3, (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(Attributes.QNAME)).withChild((DataContainerChild)BasePathSelectorTest.origin(BgpOrigin.Incomplete)).build());
        BaseBestPath processedPathIncom = this.selector.result();
        Assert.assertEquals((Object)BgpOrigin.Incomplete, (Object)processedPathIncom.getState().getOrigin());
    }
}

