/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.mode.impl;

import com.google.common.base.MoreObjects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.protocol.bgp.mode.BesthPathStateUtil;
import org.opendaylight.protocol.bgp.mode.api.BestPathState;
import org.opendaylight.protocol.bgp.parser.impl.message.update.CommunityUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.AsPath;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.Communities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.LocalPref;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.MultiExitDisc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.Origin;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.as.path.Segments;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.as.path.SegmentsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.BgpOrigin;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedData;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;

public final class BestPathStateImpl
implements BestPathState {
    private static final LoadingCache<QNameModule, NamespaceSpecificIds> PATH_CACHE = CacheBuilder.newBuilder().weakKeys().weakValues().build((CacheLoader)new CacheLoader<QNameModule, NamespaceSpecificIds>(){

        public NamespaceSpecificIds load(QNameModule key) {
            return new NamespaceSpecificIds(key);
        }
    });
    private static final Uint32 LLGR_STALE_AS_NUMBER = CommunityUtil.LLGR_STALE.getAsNumber().getValue().intern();
    private static final Uint16 LLGR_STALE_SEMANTICS = CommunityUtil.LLGR_STALE.getSemantics().intern();
    private final ContainerNode attributes;
    private long peerAs = 0L;
    private int asPathLength = 0;
    private Uint32 localPref;
    private long multiExitDisc;
    private BgpOrigin origin;
    private boolean depreferenced;
    private boolean resolved;

    public BestPathStateImpl(ContainerNode attributes) {
        this.attributes = Objects.requireNonNull(attributes);
        this.resolveValues();
    }

    private void resolveValues() {
        Optional maybeCommunities;
        UnkeyedListNode segments;
        List<Segments> segs;
        Optional maybeSegments;
        if (this.resolved) {
            return;
        }
        NamespaceSpecificIds ids = (NamespaceSpecificIds)PATH_CACHE.getUnchecked((Object)this.attributes.name().getNodeType().getModule());
        this.localPref = NormalizedNodes.findNode((NormalizedNode)this.attributes, ids.locPref).map(NormalizedData::body).orElse(null);
        Optional maybeMultiExitDisc = NormalizedNodes.findNode((NormalizedNode)this.attributes, ids.med);
        this.multiExitDisc = maybeMultiExitDisc.isPresent() ? ((Uint32)((NormalizedNode)maybeMultiExitDisc.orElseThrow()).body()).toJava() : 0L;
        Optional maybeOrigin = NormalizedNodes.findNode((NormalizedNode)this.attributes, ids.orig);
        if (maybeOrigin.isPresent()) {
            String originStr = (String)((NormalizedNode)maybeOrigin.orElseThrow()).body();
            this.origin = BgpOrigin.forName((String)originStr);
            if (this.origin == null) {
                throw new IllegalArgumentException("Unhandled origin value " + originStr);
            }
        } else {
            this.origin = null;
        }
        if ((maybeSegments = NormalizedNodes.findNode((NormalizedNode)this.attributes, ids.asPath)).isPresent() && !(segs = BestPathStateImpl.extractSegments(segments = (UnkeyedListNode)maybeSegments.orElseThrow(), ids)).isEmpty()) {
            this.peerAs = BesthPathStateUtil.getPeerAs(segs);
            this.asPathLength = BestPathStateImpl.countAsPath(segs);
        }
        this.depreferenced = (maybeCommunities = NormalizedNodes.findNode((NormalizedNode)this.attributes, (YangInstanceIdentifier.PathArgument)ids.communities)).isPresent() ? ((UnkeyedListNode)maybeCommunities.orElseThrow()).body().stream().anyMatch(community -> BestPathStateImpl.isStale(ids, community)) : false;
        this.resolved = true;
    }

    private static boolean isStale(NamespaceSpecificIds ids, UnkeyedListEntryNode community) {
        return LLGR_STALE_AS_NUMBER.equals(((DataContainerChild)community.getChildByArg((YangInstanceIdentifier.PathArgument)ids.asNumber)).body()) && LLGR_STALE_SEMANTICS.equals(((DataContainerChild)community.getChildByArg((YangInstanceIdentifier.PathArgument)ids.semantics)).body());
    }

    @Override
    public Uint32 getLocalPref() {
        this.resolveValues();
        return this.localPref;
    }

    @Override
    public long getMultiExitDisc() {
        this.resolveValues();
        return this.multiExitDisc;
    }

    @Override
    public BgpOrigin getOrigin() {
        this.resolveValues();
        return this.origin;
    }

    @Override
    public long getPeerAs() {
        this.resolveValues();
        return this.peerAs;
    }

    @Override
    public int getAsPathLength() {
        this.resolveValues();
        return this.asPathLength;
    }

    @Override
    public ContainerNode getAttributes() {
        return this.attributes;
    }

    @Override
    public boolean isDepreferenced() {
        this.resolveValues();
        return this.depreferenced;
    }

    private MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        toStringHelper.add("attributes", (Object)this.attributes);
        toStringHelper.add("localPref", (Object)this.localPref);
        toStringHelper.add("multiExitDisc", this.multiExitDisc);
        toStringHelper.add("origin", (Object)this.origin);
        toStringHelper.add("resolved", this.resolved);
        toStringHelper.add("depreferenced", this.depreferenced);
        return toStringHelper;
    }

    public String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this)).toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.attributes.hashCode();
        result = 31 * result + (this.localPref == null ? 0 : this.localPref.hashCode());
        result = 31 * result + Long.hashCode(this.multiExitDisc);
        result = 31 * result + (this.origin == null ? 0 : this.origin.hashCode());
        result = 31 * result + Boolean.hashCode(this.depreferenced);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BestPathStateImpl)) {
            return false;
        }
        BestPathStateImpl other = (BestPathStateImpl)obj;
        if (!this.attributes.equals((Object)other.attributes)) {
            return false;
        }
        if (!Objects.equals(this.localPref, other.localPref)) {
            return false;
        }
        if (this.multiExitDisc != other.multiExitDisc) {
            return false;
        }
        if (this.origin != other.origin) {
            return false;
        }
        return this.depreferenced == other.depreferenced;
    }

    private static List<Segments> extractSegments(UnkeyedListNode segments, NamespaceSpecificIds ids) {
        ArrayList<Segments> extracted = new ArrayList<Segments>();
        for (UnkeyedListEntryNode segment : segments.body()) {
            SegmentsBuilder sb = new SegmentsBuilder();
            sb.setAsSequence((List)BestPathStateImpl.extractAsList(new ArrayList(), segment, ids.asSeqNid)).setAsSet((Set)BestPathStateImpl.extractAsList(new LinkedHashSet(), segment, ids.asSetNid));
            extracted.add(sb.build());
        }
        return extracted;
    }

    private static <T extends Collection<AsNumber>> T extractAsList(T ases, UnkeyedListEntryNode segment, YangInstanceIdentifier.NodeIdentifier nid) {
        Optional maybeAsList = NormalizedNodes.findNode((NormalizedNode)segment, (YangInstanceIdentifier.PathArgument)nid);
        if (maybeAsList.isPresent()) {
            LeafSetNode list = (LeafSetNode)maybeAsList.orElseThrow();
            for (LeafSetEntryNode as : list.body()) {
                ases.add((AsNumber)new AsNumber((Uint32)as.body()));
            }
            return ases;
        }
        return null;
    }

    private static int countAsPath(List<Segments> segments) {
        int count = 0;
        boolean setPresent = false;
        for (Segments s : segments) {
            if (s.getAsSet() != null && !setPresent) {
                setPresent = true;
                ++count;
                continue;
            }
            List seq = s.getAsSequence();
            if (seq == null) continue;
            count += seq.size();
        }
        return count;
    }

    private static final class NamespaceSpecificIds {
        final List<YangInstanceIdentifier.PathArgument> asPath;
        final List<YangInstanceIdentifier.PathArgument> locPref;
        final List<YangInstanceIdentifier.PathArgument> med;
        final List<YangInstanceIdentifier.PathArgument> orig;
        final YangInstanceIdentifier.NodeIdentifier asSetNid;
        final YangInstanceIdentifier.NodeIdentifier asSeqNid;
        final YangInstanceIdentifier.NodeIdentifier communities;
        final YangInstanceIdentifier.NodeIdentifier asNumber;
        final YangInstanceIdentifier.NodeIdentifier semantics;

        NamespaceSpecificIds(@NonNull QNameModule namespace) {
            this.asPath = List.of(YangInstanceIdentifier.NodeIdentifier.create((QName)AsPath.QNAME.bindTo(namespace).intern()), YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QNameModule)namespace, (String)"segments").intern()));
            this.locPref = List.of(YangInstanceIdentifier.NodeIdentifier.create((QName)LocalPref.QNAME.bindTo(namespace).intern()), YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QNameModule)namespace, (String)"pref").intern()));
            this.med = List.of(YangInstanceIdentifier.NodeIdentifier.create((QName)MultiExitDisc.QNAME.bindTo(namespace).intern()), YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QNameModule)namespace, (String)"med").intern()));
            this.orig = List.of(YangInstanceIdentifier.NodeIdentifier.create((QName)Origin.QNAME.bindTo(namespace).intern()), YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QNameModule)namespace, (String)"value").intern()));
            this.asSetNid = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QNameModule)namespace, (String)"as-set").intern());
            this.asSeqNid = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QNameModule)namespace, (String)"as-sequence").intern());
            this.communities = YangInstanceIdentifier.NodeIdentifier.create((QName)Communities.QNAME.bindTo(namespace).intern());
            this.asNumber = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QNameModule)namespace, (String)"as-number").intern());
            this.semantics = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QNameModule)namespace, (String)"semantics").intern());
        }
    }
}

