/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.mode.impl.add;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opendaylight.protocol.bgp.mode.api.RouteEntry;
import org.opendaylight.protocol.bgp.mode.impl.BestPathStateImpl;
import org.opendaylight.protocol.bgp.mode.impl.add.AddPathBestPath;
import org.opendaylight.protocol.bgp.mode.impl.add.AddPathSelector;
import org.opendaylight.protocol.bgp.mode.impl.add.RouteKey;
import org.opendaylight.protocol.bgp.mode.impl.add.RouteKeyOffsets;
import org.opendaylight.protocol.bgp.rib.spi.RIBSupport;
import org.opendaylight.protocol.bgp.rib.spi.RouterId;
import org.opendaylight.protocol.bgp.rib.spi.entry.ActualBestPathRoutes;
import org.opendaylight.protocol.bgp.rib.spi.entry.AdvertizedRoute;
import org.opendaylight.protocol.bgp.rib.spi.entry.RouteEntryInfo;
import org.opendaylight.protocol.bgp.rib.spi.entry.StaleBestPathRoute;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.rib.tables.Routes;
import org.opendaylight.yangtools.binding.ChildOf;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AddPathAbstractRouteEntry<C extends Routes & DataObject, S extends ChildOf<? super C>>
implements RouteEntry<C, S> {
    private static final Logger LOG = LoggerFactory.getLogger(AddPathAbstractRouteEntry.class);
    private static final Uint32[] EMPTY_PATHS_ID = new Uint32[0];
    private static final MapEntryNode[] EMPTY_VALUES = new MapEntryNode[0];
    private RouteKeyOffsets offsets = RouteKeyOffsets.EMPTY;
    private MapEntryNode[] values = EMPTY_VALUES;
    private Uint32[] pathsId = EMPTY_PATHS_ID;
    private List<AddPathBestPath> bestPath;
    private List<AddPathBestPath> bestPathRemoved;
    private List<AddPathBestPath> newBestPathToBeAdvertised;
    private List<Uint32> removedPathsId;
    private long pathIdCounter = 0L;
    private boolean isNonAddPathBestPathNew;

    private MapEntryNode createRoute(RIBSupport<C, S> ribSup, String routeKey, AddPathBestPath path) {
        RouteKeyOffsets map = this.offsets;
        MapEntryNode route = map.getValue(this.values, map.offsetOf(path.getRouteKey()));
        return ribSup.createRoute(route, ribSup.createRouteListArgument(path.getPathIdLong(), routeKey), path.getAttributes());
    }

    @Override
    public final int addRoute(RouterId routerId, Uint32 remotePathId, MapEntryNode route) {
        RouteKey key = new RouteKey(routerId, remotePathId);
        int offset = this.offsets.offsetOf(key);
        if (offset < 0) {
            RouteKeyOffsets newOffsets = (RouteKeyOffsets)this.offsets.with(key);
            offset = newOffsets.offsetOf(key);
            MapEntryNode[] newRoute = newOffsets.expand(this.offsets, this.values, offset);
            Uint32[] newPathsId = newOffsets.expand(this.offsets, this.pathsId, offset);
            this.values = newRoute;
            this.offsets = newOffsets;
            this.pathsId = newPathsId;
            this.offsets.setValue(this.pathsId, offset, Uint32.valueOf((long)(++this.pathIdCounter)));
        }
        this.offsets.setValue(this.values, offset, route);
        LOG.trace("Added route {} from {}", (Object)route, (Object)routerId);
        return offset;
    }

    @Override
    public final boolean removeRoute(RouterId routerId, Uint32 remotePathId) {
        RouteKey key = new RouteKey(routerId, remotePathId);
        int offset = this.offsets.offsetOf(key);
        Uint32 pathId = this.offsets.getValue(this.pathsId, offset);
        this.values = this.offsets.removeValue(this.values, offset, EMPTY_VALUES);
        this.pathsId = this.offsets.removeValue(this.pathsId, offset, EMPTY_PATHS_ID);
        this.offsets = (RouteKeyOffsets)this.offsets.without(key);
        if (this.removedPathsId == null) {
            this.removedPathsId = new ArrayList<Uint32>();
        }
        this.removedPathsId.add(pathId);
        return this.offsets.isEmpty();
    }

    @Override
    public final Optional<StaleBestPathRoute> removeStalePaths(RIBSupport<C, S> ribSupport, String routeKey) {
        List<Object> removedPaths;
        List<Uint32> stalePaths;
        if (this.bestPathRemoved != null && !this.bestPathRemoved.isEmpty()) {
            stalePaths = this.bestPathRemoved.stream().map(AddPathBestPath::getPathIdLong).collect(Collectors.toUnmodifiableList());
            this.bestPathRemoved = null;
        } else {
            stalePaths = List.of();
        }
        if (this.removedPathsId != null) {
            removedPaths = this.removedPathsId;
            this.removedPathsId = null;
        } else {
            removedPaths = List.of();
        }
        return stalePaths.isEmpty() && removedPaths.isEmpty() ? Optional.empty() : Optional.of(new Stale<C, S>(ribSupport, routeKey, stalePaths, removedPaths, this.isNonAddPathBestPathNew));
    }

    @Override
    public final List<AdvertizedRoute<C, S>> newBestPaths(RIBSupport<C, S> ribSupport, String routeKey) {
        if (this.newBestPathToBeAdvertised == null || this.newBestPathToBeAdvertised.isEmpty()) {
            return List.of();
        }
        ArrayList<AdvertizedRoute<C, S>> advertized = new ArrayList<AdvertizedRoute<C, S>>(this.newBestPathToBeAdvertised.size());
        AddPathBestPath firstBestPath = this.bestPath.isEmpty() ? null : this.bestPath.get(0);
        for (AddPathBestPath path : this.newBestPathToBeAdvertised) {
            MapEntryNode routeAddPath = this.createRoute(ribSupport, routeKey, path);
            boolean isFirstBestPath = firstBestPath != null && firstBestPath.equals(path);
            AdvertizedRoute adv = new AdvertizedRoute(ribSupport, isFirstBestPath, routeAddPath, path.getAttributes(), path.getPeerId(), path.isDepreferenced());
            advertized.add(adv);
        }
        this.newBestPathToBeAdvertised = null;
        return advertized;
    }

    @Override
    public final List<ActualBestPathRoutes<C, S>> actualBestPaths(RIBSupport<C, S> ribSupport, RouteEntryInfo entryInfo) {
        if (this.bestPath == null || this.bestPath.isEmpty()) {
            return List.of();
        }
        ArrayList<ActualBestPathRoutes<C, S>> preexistentRoutes = new ArrayList<ActualBestPathRoutes<C, S>>();
        for (AddPathBestPath path : this.bestPath) {
            MapEntryNode route = this.createRoute(ribSupport, entryInfo.getRouteKey(), path);
            ActualBestPathRoutes adv = new ActualBestPathRoutes(ribSupport, route, path.getPeerId(), path.getAttributes(), path.isDepreferenced());
            preexistentRoutes.add(adv);
        }
        return preexistentRoutes;
    }

    @Override
    public final boolean selectBest(RIBSupport<C, S> ribSupport, long localAs) {
        int size = this.offsets.size();
        return this.isBestPathNew(size == 0 ? ImmutableList.of() : this.selectBest(ribSupport, localAs, size));
    }

    protected abstract ImmutableList<AddPathBestPath> selectBest(RIBSupport<C, S> var1, long var2, int var4);

    protected final void processOffset(RIBSupport<C, S> ribSupport, AddPathSelector selector, int offset) {
        RouteKey key = (RouteKey)this.offsets.getKey(offset);
        MapEntryNode route = this.offsets.getValue(this.values, offset);
        Uint32 pathId = this.offsets.getValue(this.pathsId, offset);
        LOG.trace("Processing router key {} route {}", (Object)key, (Object)route);
        selector.processPath(ribSupport.extractAttributes(route), key, offset, pathId);
    }

    protected final AddPathBestPath bestPathAt(RIBSupport<C, S> ribSupport, int offset) {
        MapEntryNode route = (MapEntryNode)Verify.verifyNotNull((Object)this.offsets.getValue(this.values, offset));
        return new AddPathBestPath(new BestPathStateImpl(ribSupport.extractAttributes(route)), (RouteKey)this.offsets.getKey(offset), this.offsets.getValue(this.pathsId, offset), offset);
    }

    private boolean isBestPathNew(ImmutableList<AddPathBestPath> newBestPathList) {
        this.isNonAddPathBestPathNew = !this.isNonAddPathBestPathTheSame((List<AddPathBestPath>)newBestPathList);
        this.filterRemovedPaths((List<AddPathBestPath>)newBestPathList);
        if (this.bestPathRemoved != null && !this.bestPathRemoved.isEmpty() || newBestPathList != null && !newBestPathList.equals(this.bestPath)) {
            if (this.bestPath != null) {
                this.newBestPathToBeAdvertised = new ArrayList<AddPathBestPath>((Collection<AddPathBestPath>)newBestPathList);
                this.newBestPathToBeAdvertised.removeAll(this.bestPath);
            } else {
                this.newBestPathToBeAdvertised = newBestPathList;
            }
            this.bestPath = newBestPathList;
            LOG.trace("Actual Best {}, removed best {}", this.bestPath, this.bestPathRemoved);
            return true;
        }
        return false;
    }

    private boolean isNonAddPathBestPathTheSame(List<AddPathBestPath> newBestPathList) {
        return !AddPathAbstractRouteEntry.isEmptyOrNull(this.bestPath) && !AddPathAbstractRouteEntry.isEmptyOrNull(newBestPathList) && this.bestPath.get(0).equals(newBestPathList.get(0));
    }

    private static boolean isEmptyOrNull(List<AddPathBestPath> pathList) {
        return pathList == null || pathList.isEmpty();
    }

    private void filterRemovedPaths(List<AddPathBestPath> newBestPathList) {
        if (this.bestPath == null) {
            return;
        }
        this.bestPathRemoved = new ArrayList<AddPathBestPath>(this.bestPath);
        this.bestPath.forEach(oldBest -> {
            Optional<AddPathBestPath> present = newBestPathList.stream().filter(newBest -> newBest.getPathId() == oldBest.getPathId() && newBest.getRouteKey() == oldBest.getRouteKey()).findAny();
            present.ifPresent(addPathBestPath -> this.bestPathRemoved.remove(oldBest));
        });
    }

    private static final class Stale<C extends Routes & DataObject, S extends ChildOf<? super C>>
    extends StaleBestPathRoute {
        private final List<YangInstanceIdentifier.NodeIdentifierWithPredicates> addPathRouteKeyIdentifier;
        private final List<YangInstanceIdentifier.NodeIdentifierWithPredicates> staleRouteKeyIdentifier;
        private final boolean isNonAddPathBestPathNew;

        Stale(RIBSupport<C, S> ribSupport, String routeKey, List<Uint32> staleRoutesPathIds, List<Uint32> withdrawalRoutePathIds, boolean isNonAddPathBestPathNew) {
            super(ribSupport.createRouteListArgument(routeKey));
            this.isNonAddPathBestPathNew = isNonAddPathBestPathNew;
            this.staleRouteKeyIdentifier = staleRoutesPathIds.stream().map(pathId -> ribSupport.createRouteListArgument(pathId, routeKey)).collect(Collectors.toUnmodifiableList());
            this.addPathRouteKeyIdentifier = withdrawalRoutePathIds != null ? withdrawalRoutePathIds.stream().map(pathId -> ribSupport.createRouteListArgument(pathId, routeKey)).collect(Collectors.toUnmodifiableList()) : List.of();
        }

        public List<YangInstanceIdentifier.NodeIdentifierWithPredicates> getStaleRouteKeyIdentifiers() {
            return this.staleRouteKeyIdentifier;
        }

        public List<YangInstanceIdentifier.NodeIdentifierWithPredicates> getAddPathRouteKeyIdentifiers() {
            return this.addPathRouteKeyIdentifier;
        }

        public boolean isNonAddPathBestPathNew() {
            return this.isNonAddPathBestPathNew;
        }
    }
}

