/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.bgpcep.config.loader.bmp;

import com.google.common.util.concurrent.FluentFuture;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.opendaylight.bgpcep.config.loader.spi.AbstractConfigFileProcessor;
import org.opendaylight.bgpcep.config.loader.spi.ConfigLoader;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.OdlBmpMonitors;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.monitor.config.rev200120.odl.bmp.monitors.BmpMonitorConfig;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;

@Singleton
public final class BmpMonitorConfigFileProcessor
extends AbstractConfigFileProcessor {
    @Inject
    public BmpMonitorConfigFileProcessor(ConfigLoader configLoader, DOMDataBroker dataBroker) {
        super("BMP", configLoader, dataBroker);
    }

    @PostConstruct
    public void init() {
        this.start();
    }

    @PreDestroy
    public void close() {
        this.stop();
    }

    public SchemaNodeIdentifier.Absolute fileRootSchema() {
        return SchemaNodeIdentifier.Absolute.of((QName)OdlBmpMonitors.QNAME);
    }

    protected FluentFuture<? extends CommitInfo> loadConfiguration(DOMDataBroker dataBroker, NormalizedNode dto) {
        ContainerNode odlBmpMonitors = (ContainerNode)dto;
        MapNode monitorsList = (MapNode)odlBmpMonitors.childByArg((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(BmpMonitorConfig.QNAME));
        if (monitorsList == null) {
            return CommitInfo.emptyFluentFuture();
        }
        DOMDataTreeWriteTransaction wtx = dataBroker.newWriteOnlyTransaction();
        wtx.merge(LogicalDatastoreType.CONFIGURATION, YangInstanceIdentifier.of((YangInstanceIdentifier.PathArgument[])new YangInstanceIdentifier.PathArgument[]{new YangInstanceIdentifier.NodeIdentifier(OdlBmpMonitors.QNAME), monitorsList.name()}), (NormalizedNode)monitorsList);
        return wtx.commit();
    }
}

