/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.bgpcep.config.loader.impl;

import com.google.common.base.Stopwatch;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.opendaylight.bgpcep.config.loader.impl.FileWatcher;
import org.opendaylight.bgpcep.config.loader.spi.ConfigFileProcessor;
import org.opendaylight.bgpcep.config.loader.spi.ConfigLoader;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.yangtools.concepts.AbstractRegistration;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlParserStream;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeResult;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.util.SchemaContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public final class ConfigLoaderImpl
implements ConfigLoader,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigLoaderImpl.class);
    private static final String INTERRUPTED = "InterruptedException";
    private static final String EXTENSION = "-.*\\.xml";
    private static final String INITIAL = "^";
    private static final String READ = "rw";
    private static final long TIMEOUT_SECONDS = 5L;
    private final @GuardedBy(value={"this"}) Map<String, ConfigFileProcessor> configServices = new HashMap<String, ConfigFileProcessor>();
    private final SchemaContext schemaContext;
    private final BindingNormalizedNodeSerializer bindingSerializer;
    private final String path;
    private final Thread watcherThread;
    private final File file;
    private @GuardedBy(value={"this"}) boolean closed = false;

    public ConfigLoaderImpl(SchemaContext schemaContext, BindingNormalizedNodeSerializer bindingSerializer, FileWatcher fileWatcher) {
        this.schemaContext = Objects.requireNonNull(schemaContext);
        this.bindingSerializer = Objects.requireNonNull(bindingSerializer);
        this.path = Objects.requireNonNull(fileWatcher.getPathFile());
        this.file = new File(this.path);
        this.watcherThread = new Thread(new ConfigLoaderImplRunnable(Objects.requireNonNull(fileWatcher.getWatchService())));
    }

    public void init() {
        this.watcherThread.start();
        LOG.info("Config Loader service initiated");
    }

    private synchronized void handleConfigFile(ConfigFileProcessor config, String filename) {
        NormalizedNode<?, ?> dto;
        try {
            dto = this.parseDefaultConfigFile(config, filename);
        }
        catch (IOException | XMLStreamException e) {
            LOG.warn("Failed to parse config file {}", (Object)filename, (Object)e);
            return;
        }
        LOG.info("Loading initial config {}", (Object)filename);
        config.loadConfiguration(dto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NormalizedNode<?, ?> parseDefaultConfigFile(ConfigFileProcessor config, String filename) throws IOException, XMLStreamException {
        NormalizedNodeResult result = new NormalizedNodeResult();
        NormalizedNodeStreamWriter streamWriter = ImmutableNormalizedNodeStreamWriter.from((NormalizedNodeResult)result);
        File newFile = new File(this.path, filename);
        FileChannel channel = new RandomAccessFile(newFile, READ).getChannel();
        FileLock lock = null;
        Stopwatch stopwatch = Stopwatch.createStarted();
        while (lock == null || stopwatch.elapsed(TimeUnit.SECONDS) > 5L) {
            try {
                lock = channel.tryLock();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (lock != null) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                LOG.warn("Failed to lock xml", (Throwable)e);
            }
        }
        try (FileInputStream resourceAsStream = new FileInputStream(newFile);){
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader reader = factory.createXMLStreamReader(resourceAsStream);
            SchemaNode schemaNode = SchemaContextUtil.findDataSchemaNode((SchemaContext)this.schemaContext, (SchemaPath)config.getSchemaPath());
            try (XmlParserStream xmlParser = XmlParserStream.create((NormalizedNodeStreamWriter)streamWriter, (SchemaContext)this.schemaContext, (SchemaNode)schemaNode);){
                xmlParser.parse(reader);
            }
            catch (IOException | URISyntaxException | XMLStreamException | SAXException e) {
                LOG.warn("Failed to parse xml", (Throwable)e);
            }
            finally {
                reader.close();
                channel.close();
            }
        }
        return result.getResult();
    }

    public synchronized AbstractRegistration registerConfigFile(ConfigFileProcessor config) {
        final String pattern = INITIAL + config.getSchemaPath().getLastComponent().getLocalName() + EXTENSION;
        this.configServices.put(pattern, config);
        File[] fList = this.file.listFiles();
        ArrayList<String> newFiles = new ArrayList<String>();
        if (fList != null) {
            for (File newFile : fList) {
                String filename;
                if (!newFile.isFile() || !Pattern.matches(pattern, filename = newFile.getName())) continue;
                newFiles.add(filename);
            }
        }
        for (String filename : newFiles) {
            this.handleConfigFile(config, filename);
        }
        return new AbstractRegistration(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void removeRegistration() {
                ConfigLoaderImpl configLoaderImpl = ConfigLoaderImpl.this;
                synchronized (configLoaderImpl) {
                    ConfigLoaderImpl.this.configServices.remove(pattern);
                }
            }
        };
    }

    public BindingNormalizedNodeSerializer getBindingNormalizedNodeSerializer() {
        return this.bindingSerializer;
    }

    @Override
    public synchronized void close() {
        LOG.info("Config Loader service closed");
        this.closed = true;
        this.watcherThread.interrupt();
    }

    private class ConfigLoaderImplRunnable
    implements Runnable {
        private final @GuardedBy(value={"this"}) WatchService watchService;

        ConfigLoaderImplRunnable(WatchService watchService) {
            this.watchService = watchService;
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                this.handleChanges();
            }
        }

        private synchronized void handleChanges() {
            WatchKey key;
            try {
                key = this.watchService.take();
            }
            catch (InterruptedException | ClosedWatchServiceException e) {
                if (!ConfigLoaderImpl.this.closed) {
                    LOG.warn(ConfigLoaderImpl.INTERRUPTED, (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                return;
            }
            if (key != null) {
                List<String> fileNames = key.pollEvents().stream().map(event -> event.context().toString()).collect(Collectors.toList());
                fileNames.forEach(this::handleEvent);
                boolean reset = key.reset();
                if (!reset) {
                    LOG.warn("Could not reset the watch key.");
                }
            }
        }

        private synchronized void handleEvent(String filename) {
            ConfigLoaderImpl.this.configServices.entrySet().stream().filter(entry -> Pattern.matches((String)entry.getKey(), filename)).forEach(entry -> ConfigLoaderImpl.this.handleConfigFile((ConfigFileProcessor)entry.getValue(), filename));
        }
    }
}

