/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.bgpcep.config.loader.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchService;
import org.opendaylight.bgpcep.config.loader.impl.FileWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileWatcherImpl
implements FileWatcher,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(FileWatcherImpl.class);
    private static final String INTERRUPTED = "InterruptedException";
    private static final String BGPCEP_CONFIG_FOLDER = "bgpcep";
    private static final String DEFAULT_APP_CONFIG_FILE_PATH = "etc" + File.separator + "opendaylight" + File.separator + "bgpcep" + File.separator;
    private static final Path PATH = Paths.get(DEFAULT_APP_CONFIG_FILE_PATH, new String[0]);
    private final WatchService watchService = FileSystems.getDefault().newWatchService();

    public FileWatcherImpl() throws IOException {
        File file = new File(DEFAULT_APP_CONFIG_FILE_PATH);
        if (!file.exists() && !file.mkdirs()) {
            LOG.warn("Failed to create config directory {}", (Object)DEFAULT_APP_CONFIG_FILE_PATH);
            return;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                this.watchService.close();
            }
            catch (IOException e) {
                LOG.warn(INTERRUPTED, (Throwable)e);
            }
        }));
        PATH.register(this.watchService, StandardWatchEventKinds.OVERFLOW, StandardWatchEventKinds.ENTRY_CREATE);
        LOG.info("File Watcher service initiated");
    }

    @Override
    public String getPathFile() {
        return DEFAULT_APP_CONFIG_FILE_PATH;
    }

    @Override
    public synchronized WatchService getWatchService() {
        return this.watchService;
    }

    @Override
    public synchronized void close() throws Exception {
        if (this.watchService != null) {
            this.watchService.close();
        }
    }
}

