/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.bgpcep.config.loader.impl;

import java.nio.file.ClosedWatchServiceException;
import java.nio.file.WatchKey;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opendaylight.bgpcep.config.loader.impl.AbstractConfigLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractWatchingConfigLoader
extends AbstractConfigLoader {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractWatchingConfigLoader.class);
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Thread watcherThread = new Thread(this::dispatchEvents, "Config Loader Watcher Thread");

    AbstractWatchingConfigLoader() {
        this.watcherThread.setDaemon(true);
    }

    final void start() {
        this.watcherThread.start();
        LOG.info("Config Loader service started");
    }

    final void stop() {
        LOG.info("Config Loader service stopping");
        this.closed.set(true);
        this.watcherThread.interrupt();
        try {
            this.watcherThread.join();
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while waiting for watcher thread to terminate", (Throwable)e);
        }
        LOG.info("Config Loader service stopped");
    }

    abstract WatchKey takeEvent() throws InterruptedException;

    private void dispatchEvents() {
        while (!this.closed.get()) {
            WatchKey key;
            try {
                key = this.takeEvent();
            }
            catch (InterruptedException | ClosedWatchServiceException e) {
                if (!this.closed.get()) {
                    LOG.warn("Exception while waiting for events, exiting", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                return;
            }
            if (key == null) continue;
            key.pollEvents().stream().map(event -> event.context().toString()).forEach(this::handleEvent);
            if (key.reset()) continue;
            LOG.warn("Could not reset the watch key.");
        }
    }
}

