/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.bgpcep.config.loader.impl;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Cleaner;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchService;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Singleton;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.bgpcep.config.loader.impl.FileWatcher;
import org.opendaylight.yangtools.concepts.AbstractRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Component(immediate=true, service={FileWatcher.class})
public final class DefaultFileWatcher
extends AbstractRegistration
implements FileWatcher {
    private static final Cleaner CLEANER = Cleaner.create();
    private static final Logger LOG = LoggerFactory.getLogger(DefaultFileWatcher.class);
    private static final Path PATH = Paths.get("etc", "opendaylight", "bgpcep");
    private final State state = new State(FileSystems.getDefault().newWatchService());
    private final Cleaner.Cleanable cleanable = CLEANER.register(this, this.state);

    @Override
    public String getPathFile() {
        return PATH.toString();
    }

    @Override
    public WatchService getWatchService() {
        return this.state.watchService;
    }

    @PostConstruct
    @Activate
    public void activate() throws IOException {
        File file = new File(PATH.toString());
        if (!file.exists() && !file.mkdirs()) {
            LOG.warn("Failed to create config directory {}", (Object)PATH);
            return;
        }
        PATH.register(this.getWatchService(), StandardWatchEventKinds.OVERFLOW, StandardWatchEventKinds.ENTRY_CREATE);
        LOG.info("File Watcher service started");
    }

    @PreDestroy
    @Deactivate
    public void deactivate() {
        this.close();
    }

    protected void removeRegistration() {
        this.cleanable.clean();
        LOG.info("File Watcher service stopped");
    }

    private static final class State
    implements Runnable {
        final @NonNull WatchService watchService;

        State(WatchService watchService) {
            this.watchService = Objects.requireNonNull(watchService);
        }

        @Override
        public void run() {
            try {
                this.watchService.close();
            }
            catch (IOException e) {
                LOG.warn("Failed to close watch service", (Throwable)e);
            }
        }
    }
}

