/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.bgpcep.config.loader.impl;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opendaylight.bgpcep.config.loader.impl.AbstractConfigLoaderTest;
import org.opendaylight.bgpcep.config.loader.spi.ConfigFileProcessor;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.network.instance.rev151018.network.instance.top.NetworkInstances;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.network.instance.rev151018.network.instance.top.network.instances.NetworkInstance;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.network.instance.rev151018.network.instance.top.network.instances.network.instance.Protocols;
import org.opendaylight.yangtools.concepts.AbstractRegistration;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;

public class ConfigLoaderImplTest
extends AbstractConfigLoaderTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        ((ConfigFileProcessor)Mockito.doReturn((Object)SchemaNodeIdentifier.Absolute.of((QName[])new QName[]{NetworkInstances.QNAME, NetworkInstance.QNAME, Protocols.QNAME})).when((Object)this.processor)).fileRootSchema();
        ((ConfigFileProcessor)Mockito.doReturn((Object)"processor").when((Object)this.processor)).toString();
    }

    @Override
    protected String getResourceFolder() {
        return ClassLoader.getSystemClassLoader().getResource("etc/opendaylight/bgpcep").getPath();
    }

    @Test
    public void configLoaderImplTest() {
        Assert.assertNotNull((Object)ClassLoader.getSystemClassLoader().getResource("etc/opendaylight/bgpcep/protocols-config.xml"));
        AbstractRegistration ticket = this.configLoader.registerConfigFile(this.processor);
        ((ConfigFileProcessor)Mockito.verify((Object)this.processor)).loadConfiguration((NormalizedNode)ArgumentMatchers.any());
        this.configLoader.triggerEvent("protocols-config.xml");
        ((ConfigFileProcessor)Mockito.verify((Object)this.processor, (VerificationMode)Mockito.times((int)2))).loadConfiguration((NormalizedNode)ArgumentMatchers.any());
        ticket.close();
        this.configLoader.triggerEvent("protocols-config.xml");
        ((ConfigFileProcessor)Mockito.verify((Object)this.processor, (VerificationMode)Mockito.times((int)2))).loadConfiguration((NormalizedNode)ArgumentMatchers.any());
    }
}

