/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.bgpcep.config.loader.impl;

import java.io.File;
import org.junit.Before;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.opendaylight.bgpcep.config.loader.impl.AbstractConfigLoader;
import org.opendaylight.bgpcep.config.loader.spi.ConfigFileProcessor;
import org.opendaylight.mdsal.binding.dom.adapter.test.AbstractConcurrentDataBrokerTest;
import org.opendaylight.mdsal.binding.dom.adapter.test.AbstractDataBrokerTestCustomizer;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

public abstract class AbstractConfigLoaderTest
extends AbstractConcurrentDataBrokerTest {
    protected final TestConfigLoader configLoader = new TestConfigLoader();
    @Mock
    ConfigFileProcessor processor;
    protected DOMSchemaService schemaService;

    public AbstractConfigLoaderTest() {
        super(true);
    }

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)((Object)this));
        ((ConfigFileProcessor)Mockito.doNothing().when((Object)this.processor)).loadConfiguration((NormalizedNode)ArgumentMatchers.any());
        this.configLoader.updateModelContext(this.getSchemaContext());
    }

    protected AbstractDataBrokerTestCustomizer createDataBrokerTestCustomizer() {
        AbstractDataBrokerTestCustomizer customizer = super.createDataBrokerTestCustomizer();
        this.schemaService = customizer.getSchemaService();
        return customizer;
    }

    protected String getResourceFolder() {
        return ClassLoader.getSystemClassLoader().getResource("initial").getPath();
    }

    protected final class TestConfigLoader
    extends AbstractConfigLoader {
        protected TestConfigLoader() {
        }

        File directory() {
            return new File(AbstractConfigLoaderTest.this.getResourceFolder());
        }

        public void triggerEvent(String filename) {
            this.handleEvent(filename);
        }
    }
}

