/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.bgpcep.config.loader.impl;

import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.opendaylight.bgpcep.config.loader.impl.FileWatcher;
import org.opendaylight.bgpcep.config.loader.impl.SimpleConfigLoader;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class SimpleConfigLoaderTest {
    @Mock
    private FileWatcher watcher;
    @Mock
    private WatchService watchService;
    @Mock
    private WatchKey watchKey;
    @Mock
    private WatchEvent<?> watchEvent;
    @Mock
    private BindingRuntimeContext bindingContext;
    @Mock
    private EffectiveModelContext domContext;
    private SimpleConfigLoader loader;

    @Before
    public void before() throws InterruptedException {
        ((BindingRuntimeContext)Mockito.doReturn((Object)this.domContext).when((Object)this.bindingContext)).getEffectiveModelContext();
        ((FileWatcher)Mockito.doReturn((Object)this.watchService).when((Object)this.watcher)).getWatchService();
        ((FileWatcher)Mockito.doReturn((Object)"foo").when((Object)this.watcher)).getPathFile();
        ((WatchService)Mockito.doReturn((Object)this.watchKey).when((Object)this.watchService)).take();
        ((WatchKey)Mockito.doAnswer(inv -> {
            ((WatchKey)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("enough!")}).when((Object)this.watchKey)).pollEvents();
            return List.of(this.watchEvent);
        }).when((Object)this.watchKey)).pollEvents();
        ((WatchEvent)Mockito.doReturn((Object)"watchEvent").when(this.watchEvent)).context();
        ((WatchKey)Mockito.doReturn((Object)true).when((Object)this.watchKey)).reset();
        this.loader = new SimpleConfigLoader(this.watcher, this.bindingContext);
    }

    @After
    public void after() {
        this.loader.close();
    }

    @Test
    public void testSimpleConfigLoader() {
        this.loader.init();
        ((WatchKey)Mockito.verify((Object)this.watchKey, (VerificationMode)Mockito.timeout((long)10000L))).reset();
    }
}

