/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.bgpcep.config.loader.impl;

import com.google.common.base.Stopwatch;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.Holding;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.bgpcep.config.loader.spi.ConfigFileProcessor;
import org.opendaylight.bgpcep.config.loader.spi.ConfigLoader;
import org.opendaylight.yangtools.concepts.AbstractRegistration;
import org.opendaylight.yangtools.util.xml.UntrustedXML;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlParserStream;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeResult;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveStatementInference;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractConfigLoader
implements ConfigLoader {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractConfigLoader.class);
    private static final String EXTENSION = "-.*\\.xml";
    private static final String INITIAL = "^";
    private static final String READ = "rw";
    private static final long TIMEOUT_NANOS = TimeUnit.SECONDS.toNanos(5L);
    private final @GuardedBy(value={"this"}) Map<ProcessorRegistration, ProcessorContext> configServices = new HashMap<ProcessorRegistration, ProcessorContext>();
    private @GuardedBy(value={"this"}) EffectiveModelContext currentContext;

    AbstractConfigLoader() {
    }

    public final synchronized AbstractRegistration registerConfigFile(ConfigFileProcessor config) {
        String patternStr = INITIAL + config.fileRootSchema().lastNodeIdentifier().getLocalName() + EXTENSION;
        ProcessorContext context = new ProcessorContext(config, Pattern.compile(patternStr));
        context.updateSchemaNode(this.currentContext);
        ProcessorRegistration reg = new ProcessorRegistration();
        this.configServices.put(reg, context);
        File[] fList = this.directory().listFiles();
        if (fList != null) {
            ArrayList<String> newFiles = new ArrayList<String>();
            for (File newFile : fList) {
                String filename;
                if (!newFile.isFile() || !context.matchesFile(filename = newFile.getName())) continue;
                newFiles.add(filename);
            }
            for (String filename : newFiles) {
                this.handleConfigFile(context, filename);
            }
        }
        return reg;
    }

    final synchronized void handleEvent(String filename) {
        this.configServices.values().stream().filter(context -> context.matchesFile(filename)).forEach(context -> this.handleConfigFile((ProcessorContext)context, filename));
    }

    final synchronized void updateModelContext(EffectiveModelContext newModelContext) {
        if (!Objects.equals(this.currentContext, newModelContext)) {
            this.currentContext = newModelContext;
            this.configServices.values().stream().forEach(context -> context.updateSchemaNode(newModelContext));
        }
    }

    abstract @NonNull File directory();

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="https://github.com/spotbugs/spotbugs/issues/811")
    private synchronized void unregister(ProcessorRegistration reg) {
        this.configServices.remove((Object)reg);
    }

    @Holding(value={"this"})
    private void handleConfigFile(ProcessorContext context, String filename) {
        NormalizedNode dto;
        EffectiveStatementInference schema = context.schema;
        if (schema == null) {
            LOG.info("No schema present for {}, ignoring file {}", (Object)context.processor.fileRootSchema(), (Object)filename);
            return;
        }
        try {
            dto = this.parseDefaultConfigFile(schema, filename);
        }
        catch (IOException | XMLStreamException e) {
            LOG.warn("Failed to parse config file {}", (Object)filename, (Object)e);
            return;
        }
        LOG.info("Loading initial config {}", (Object)filename);
        context.processor.loadConfiguration(dto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Holding(value={"this"})
    private NormalizedNode parseDefaultConfigFile(EffectiveStatementInference schema, String filename) throws IOException, XMLStreamException {
        NormalizedNodeResult result = new NormalizedNodeResult();
        NormalizedNodeStreamWriter streamWriter = ImmutableNormalizedNodeStreamWriter.from((NormalizedNodeResult)result);
        File newFile = new File(this.directory(), filename);
        try (RandomAccessFile raf = new RandomAccessFile(newFile, READ);){
            FileChannel channel = raf.getChannel();
            FileLock lock = null;
            Stopwatch stopwatch = Stopwatch.createStarted();
            while (lock == null || stopwatch.elapsed(TimeUnit.NANOSECONDS) > TIMEOUT_NANOS) {
                try {
                    lock = channel.tryLock();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                if (lock != null) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    LOG.warn("Failed to lock xml", (Throwable)e);
                }
            }
            try (FileInputStream resourceAsStream = new FileInputStream(newFile);
                 XMLStreamReader reader = UntrustedXML.createXMLStreamReader((InputStream)resourceAsStream);
                 XmlParserStream xmlParser = XmlParserStream.create((NormalizedNodeStreamWriter)streamWriter, (EffectiveStatementInference)schema);){
                xmlParser.parse(reader);
            }
        }
        return result.getResult();
    }

    private static final class ProcessorContext {
        private final ConfigFileProcessor processor;
        private final Pattern pattern;
        private EffectiveStatementInference schema;

        ProcessorContext(ConfigFileProcessor processor, Pattern pattern) {
            this.processor = processor;
            this.pattern = pattern;
        }

        boolean matchesFile(String filename) {
            return this.pattern.matcher(filename).matches();
        }

        void updateSchemaNode(EffectiveModelContext newContext) {
            this.schema = newContext != null ? SchemaInferenceStack.of((EffectiveModelContext)newContext, (SchemaNodeIdentifier.Absolute)this.processor.fileRootSchema()).toInference() : null;
        }
    }

    private final class ProcessorRegistration
    extends AbstractRegistration {
        private ProcessorRegistration() {
        }

        protected void removeRegistration() {
            AbstractConfigLoader.this.unregister(this);
        }
    }
}

