/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.bgpcep.config.loader.impl;

import com.google.common.annotations.Beta;
import java.io.File;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.bgpcep.config.loader.impl.AbstractWatchingConfigLoader;
import org.opendaylight.bgpcep.config.loader.impl.FileWatcher;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeContext;

@Singleton
@Beta
public final class SimpleConfigLoader
extends AbstractWatchingConfigLoader
implements AutoCloseable {
    private final @NonNull WatchService watchService;
    private final @NonNull File directory;

    @Inject
    public SimpleConfigLoader(FileWatcher fileWatcher, BindingRuntimeContext runtimeContext) {
        this.updateModelContext(runtimeContext.getEffectiveModelContext());
        this.watchService = fileWatcher.getWatchService();
        this.directory = new File(fileWatcher.getPathFile());
    }

    @PostConstruct
    public void init() {
        this.start();
    }

    @Override
    @PreDestroy
    public void close() {
        this.stop();
    }

    @Override
    File directory() {
        return this.directory;
    }

    @Override
    WatchKey takeEvent() throws InterruptedException {
        return this.watchService.take();
    }
}

