/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.bgpcep.config.loader.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import java.io.File;
import java.nio.file.WatchKey;
import org.opendaylight.bgpcep.config.loader.impl.AbstractWatchingConfigLoader;
import org.opendaylight.bgpcep.config.loader.impl.FileWatcher;
import org.opendaylight.bgpcep.config.loader.spi.ConfigLoader;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;

@Beta
@Component(immediate=true, service={ConfigLoader.class})
public final class OSGiConfigLoader
extends AbstractWatchingConfigLoader {
    @Reference
    FileWatcher watcher;
    private File directory;

    @Reference(policy=ReferencePolicy.DYNAMIC, updated="setRuntimeContext", unbind="setRuntimeContext")
    void setRuntimeContext(BindingRuntimeContext runtimeContext) {
        this.updateModelContext(runtimeContext.modelContext());
    }

    @Activate
    void activate() {
        this.directory = new File(this.watcher.getPathFile());
        this.start();
    }

    @Deactivate
    void deactivate() {
        try {
            this.stop();
        }
        finally {
            this.directory = null;
        }
    }

    @Override
    File directory() {
        return (File)Verify.verifyNotNull((Object)this.directory);
    }

    @Override
    WatchKey takeEvent() throws InterruptedException {
        return this.watcher.getWatchService().take();
    }
}

