/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.bgpcep.config.loader.spi;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FluentFuture;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.bgpcep.config.loader.spi.ConfigFileProcessor;
import org.opendaylight.bgpcep.config.loader.spi.ConfigLoader;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.yangtools.concepts.AbstractRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigFileProcessor
implements ConfigFileProcessor,
Registration {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractConfigFileProcessor.class);
    private final @NonNull ConfigLoader configLoader;
    private final @NonNull DOMDataBroker dataBroker;
    private final String name;
    private AbstractRegistration reg;

    protected AbstractConfigFileProcessor(String name, ConfigLoader configLoader, DOMDataBroker dataBroker) {
        this.name = Objects.requireNonNull(name);
        this.configLoader = Objects.requireNonNull(configLoader);
        this.dataBroker = Objects.requireNonNull(dataBroker);
    }

    @Override
    public final void loadConfiguration(NormalizedNode<?, ?> dto) {
        FluentFuture<? extends CommitInfo> future = this.loadConfiguration(this.dataBroker, dto);
        try {
            future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("Failed to create {} configuration", (Object)this.name, (Object)e);
        }
    }

    protected abstract @NonNull FluentFuture<? extends CommitInfo> loadConfiguration(@NonNull DOMDataBroker var1, @NonNull NormalizedNode<?, ?> var2);

    protected final void start() {
        Preconditions.checkState((this.reg == null ? 1 : 0) != 0, (String)"%s Config Loader already started", (Object)this.name);
        this.reg = this.configLoader.registerConfigFile(this);
        LOG.info("{} Config Loader registered", (Object)this.name);
    }

    protected final void stop() {
        if (this.reg != null) {
            this.reg.close();
            this.reg = null;
            LOG.info("{} Config Loader unregistered", (Object)this.name);
        }
    }
}

