package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Range;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.lang.Override;
import java.lang.String;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.Objects;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;

public class DecimalBandwidth
 implements ScalarTypeObject<BigDecimal>, Serializable {
    private static final long serialVersionUID = 8069688163137208190L;
    public static final String _UNITS = "bytes/second";
    private final BigDecimal _value;

    private static final Range<java.math.BigDecimal>[] CHECK_VALUERANGE_RANGES;
    static {
        @SuppressWarnings("unchecked")
        final Range<java.math.BigDecimal>[] a = (Range<java.math.BigDecimal>[]) Array.newInstance(Range.class, 1);
        a[0] = Range.closed(new java.math.BigDecimal("-92233720368547758.08"), new java.math.BigDecimal("92233720368547758.07"));
        CHECK_VALUERANGE_RANGES = a;
    }
    private static void check_valueRange(final java.math.BigDecimal value) {
        for (Range<java.math.BigDecimal> r : CHECK_VALUERANGE_RANGES) {
            if (r.contains(value)) {
                return;
            }
        }
        CodeHelpers.throwInvalidRange(CHECK_VALUERANGE_RANGES, value);
    }

    @ConstructorParameters("value")
    @ConstructorProperties("value")
    public DecimalBandwidth(BigDecimal _value) {
        if (_value != null) {
            check_valueRange(_value);
        }
        
        CodeHelpers.requireValue(_value);
    
        this._value = _value;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public DecimalBandwidth(DecimalBandwidth source) {
        this._value = source._value;
    }

    public static DecimalBandwidth getDefaultInstance(final String defaultValue) {
        return new DecimalBandwidth(new BigDecimal(defaultValue));
    }

    @Override
    public BigDecimal getValue() {
        return _value;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_value);
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DecimalBandwidth)) {
            return false;
        }
        final DecimalBandwidth other = (DecimalBandwidth) obj;
        if (!Objects.equals(_value, other._value)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(DecimalBandwidth.class);
        CodeHelpers.appendValue(helper, "_value", _value);
        CodeHelpers.appendValue(helper, "_UNITS", _UNITS);
        return helper.toString();
    }
}

