package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.EdgeAttributes;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint64;

/**
 * Unidirectional Edge (link) representation for the network topology
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>graph</b>
 * <pre>
 * grouping edge {
 *   leaf edge-id {
 *     type uint64;
 *   }
 *   leaf local-vertex-id {
 *     type uint64;
 *   }
 *   leaf remote-vertex-id {
 *     type uint64;
 *   }
 *   leaf name {
 *     type string;
 *   }
 *   container edge-attributes {
 *     uses edge-attributes;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>graph/edge</i>
 *
 */
public interface Edge
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("edge");

    @Override
    Class<? extends Edge> implementedInterface();
    
    /**
     * @return <code>org.opendaylight.yangtools.yang.common.Uint64</code> <code>edgeId</code>, or <code>null</code> if not present
     */
    @Nullable Uint64 getEdgeId();
    
    /**
     * Vertex identifier where the Edge is attached
     *
     *
     *
     * @return <code>org.opendaylight.yangtools.yang.common.Uint64</code> <code>localVertexId</code>, or <code>null</code> if not present
     */
    @Nullable Uint64 getLocalVertexId();
    
    /**
     * Vertex identifier where the Edge is going to
     *
     *
     *
     * @return <code>org.opendaylight.yangtools.yang.common.Uint64</code> <code>remoteVertexId</code>, or <code>null</code> if not present
     */
    @Nullable Uint64 getRemoteVertexId();
    
    /**
     * Edge name
     *
     *
     *
     * @return <code>java.lang.String</code> <code>name</code>, or <code>null</code> if not present
     */
    @Nullable String getName();
    
    /**
     * All attributes associated to the Edge
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.EdgeAttributes</code> <code>edgeAttributes</code>, or <code>null</code> if not present
     */
    @Nullable EdgeAttributes getEdgeAttributes();

}

