package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.attributes.MinMaxDelay;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.attributes.UnreservedBandwidth;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Attributes associated with the Edge
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>graph</b>
 * <pre>
 * grouping edge-attributes {
 *   leaf metric {
 *     type uint32;
 *   }
 *   leaf te-metric {
 *     type uint32;
 *   }
 *   leaf admin-group {
 *     type uint32;
 *   }
 *   leaf local-address {
 *     type inet:ip-address;
 *   }
 *   leaf remote-address {
 *     type inet:ip-address;
 *   }
 *   leaf local-identifier {
 *     type uint32;
 *   }
 *   leaf remote-identifier {
 *     type uint32;
 *   }
 *   leaf max-link-bandwidth {
 *     type decimal-bandwidth;
 *   }
 *   leaf max-resv-link-bandwidth {
 *     type decimal-bandwidth;
 *   }
 *   list unreserved-bandwidth {
 *     max-elements 8;
 *     ordered-by user;
 *     key class-type;
 *     leaf class-type {
 *       type uint8 {
 *         range 0..7;
 *       }
 *     }
 *     leaf bandwidth {
 *       type decimal-bandwidth;
 *     }
 *   }
 *   leaf delay {
 *     type delay;
 *   }
 *   container min-max-delay {
 *     leaf min-delay {
 *       type delay;
 *     }
 *     leaf max-delay {
 *       type delay;
 *     }
 *   }
 *   leaf jitter {
 *     type delay;
 *   }
 *   leaf loss {
 *     type loss;
 *   }
 *   leaf residual-bandwidth {
 *     type decimal-bandwidth;
 *   }
 *   leaf available-bandwidth {
 *     type decimal-bandwidth;
 *   }
 *   leaf utilized-bandwidth {
 *     type decimal-bandwidth;
 *   }
 *   leaf adj-sid {
 *     units "MPLS label";
 *     type uint32;
 *   }
 *   leaf backup-adj-sid {
 *     units "MPLS label";
 *     type uint32;
 *   }
 *   leaf-list srlgs {
 *     type uint32;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>graph/edge-attributes</i>
 *
 */
public interface EdgeAttributes
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("edge-attributes");

    @Override
    Class<? extends EdgeAttributes> implementedInterface();
    
    /**
     * Standard Metric from the routing protocol
     *
     *
     *
     * @return <code>org.opendaylight.yangtools.yang.common.Uint32</code> <code>metric</code>, or <code>null</code> if not present
     */
    @Nullable Uint32 getMetric();
    
    /**
     * Traffic Engineering Metric
     *
     *
     *
     * @return <code>org.opendaylight.yangtools.yang.common.Uint32</code> <code>teMetric</code>, or <code>null</code> if not present
     */
    @Nullable Uint32 getTeMetric();
    
    /**
     * Administrative group or color of the link
     *
     *
     *
     * @return <code>org.opendaylight.yangtools.yang.common.Uint32</code> <code>adminGroup</code>, or <code>null</code> if not present
     */
    @Nullable Uint32 getAdminGroup();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress</code> <code>localAddress</code>, or <code>null</code> if not present
     */
    @Nullable IpAddress getLocalAddress();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress</code> <code>remoteAddress</code>, or <code>null</code> if not present
     */
    @Nullable IpAddress getRemoteAddress();
    
    /**
     * @return <code>org.opendaylight.yangtools.yang.common.Uint32</code> <code>localIdentifier</code>, or <code>null</code> if not present
     */
    @Nullable Uint32 getLocalIdentifier();
    
    /**
     * @return <code>org.opendaylight.yangtools.yang.common.Uint32</code> <code>remoteIdentifier</code>, or <code>null</code> if not present
     */
    @Nullable Uint32 getRemoteIdentifier();
    
    /**
     * Maximum bandwidth that can be use
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.DecimalBandwidth</code> <code>maxLinkBandwidth</code>, or <code>null</code> if not present
     */
    @Nullable DecimalBandwidth getMaxLinkBandwidth();
    
    /**
     * Maximum amount of bandwidth that can be reserved
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.DecimalBandwidth</code> <code>maxResvLinkBandwidth</code>, or <code>null</code> if not present
     */
    @Nullable DecimalBandwidth getMaxResvLinkBandwidth();
    
    /**
     * Unreserved bandwidth for 0-7 class type
     *
     *
     *
     * @return <code>java.util.List</code> <code>unreservedBandwidth</code>, or <code>null</code> if not present
     */
    @Nullable List<UnreservedBandwidth> getUnreservedBandwidth();
    
    /**
     * @return <code>java.util.List</code> <code>unreservedBandwidth</code>, or an empty list if it is not present
     */
    default @NonNull List<UnreservedBandwidth> nonnullUnreservedBandwidth() {
        return CodeHelpers.nonnull(getUnreservedBandwidth());
    }
    
    /**
     * Unidirectional Delay.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Delay</code> <code>delay</code>, or <code>null</code> if not present
     */
    @Nullable Delay getDelay();
    
    /**
     * Min/Max Unidirectional Delay
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.attributes.MinMaxDelay</code> <code>minMaxDelay</code>, or <code>null</code> if not present
     */
    @Nullable MinMaxDelay getMinMaxDelay();
    
    /**
     * Unidirectional Delay Variation
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Delay</code> <code>jitter</code>, or <code>null</code> if not present
     */
    @Nullable Delay getJitter();
    
    /**
     * Unidirectional Loss
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Loss</code> <code>loss</code>, or <code>null</code> if not present
     */
    @Nullable Loss getLoss();
    
    /**
     * Unidirectional Residual Bandwidth
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.DecimalBandwidth</code> <code>residualBandwidth</code>, or <code>null</code> if not present
     */
    @Nullable DecimalBandwidth getResidualBandwidth();
    
    /**
     * Unidirectional Available Bandwidth
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.DecimalBandwidth</code> <code>availableBandwidth</code>, or <code>null</code> if not present
     */
    @Nullable DecimalBandwidth getAvailableBandwidth();
    
    /**
     * Unidirectional Utilized Bandwidth
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.DecimalBandwidth</code> <code>utilizedBandwidth</code>, or <code>null</code> if not present
     */
    @Nullable DecimalBandwidth getUtilizedBandwidth();
    
    /**
     * Segment Routing Adjacency Identifier
     *
     *
     *
     * @return <code>org.opendaylight.yangtools.yang.common.Uint32</code> <code>adjSid</code>, or <code>null</code> if not present
     */
    @Nullable Uint32 getAdjSid();
    
    /**
     * Segment Routing Backup Adjacency Identifier
     *
     *
     *
     * @return <code>org.opendaylight.yangtools.yang.common.Uint32</code> <code>backupAdjSid</code>, or <code>null</code> if not present
     */
    @Nullable Uint32 getBackupAdjSid();
    
    /**
     * List of Shared Risk Link Group Attributes
     *
     *
     *
     * @return <code>java.util.List</code> <code>srlgs</code>, or <code>null</code> if not present
     */
    @Nullable List<Uint32> getSrlgs();

}

