package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * This module contains the graph data model for network topology and datastore 
 * used in the Path Computation Algorithms. Copyright (c)2019 Orange. All rights 
 * reserved. This program and the accompanying materials are made available under 
 * the terms of the Eclipse Public License v1.0 which accompanies this 
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>graph</b>
 * <pre>
 * module graph {
 *   yang-version 1;
 *   namespace urn:opendaylight:params:xml:ns:yang:graph;
 *   prefix graph;
 *   import ietf-inet-types {
 *     prefix inet;
 *     revision-date 2013-07-15;
 *   }
 *   import odl-uint24 {
 *     prefix uint24;
 *   }
 *   revision 2019-11-25 {
 *   }
 *   typedef delay {
 *     units microseconds;
 *     type uint24:uint24;
 *   }
 *   typedef loss {
 *     units 0.000003%;
 *     type uint24:uint24;
 *   }
 *   typedef decimal-bandwidth {
 *     units bytes/second;
 *     type decimal64 {
 *       fraction-digits 2;
 *     }
 *   }
 *   grouping edge-attributes {
 *     leaf metric {
 *       type uint32;
 *     }
 *     leaf te-metric {
 *       type uint32;
 *     }
 *     leaf admin-group {
 *       type uint32;
 *     }
 *     leaf local-address {
 *       type inet:ip-address;
 *     }
 *     leaf remote-address {
 *       type inet:ip-address;
 *     }
 *     leaf local-identifier {
 *       type uint32;
 *     }
 *     leaf remote-identifier {
 *       type uint32;
 *     }
 *     leaf max-link-bandwidth {
 *       type decimal-bandwidth;
 *     }
 *     leaf max-resv-link-bandwidth {
 *       type decimal-bandwidth;
 *     }
 *     list unreserved-bandwidth {
 *       max-elements 8;
 *       ordered-by user;
 *       key class-type;
 *       leaf class-type {
 *         type uint8 {
 *           range 0..7;
 *         }
 *       }
 *       leaf bandwidth {
 *         type decimal-bandwidth;
 *       }
 *     }
 *     leaf delay {
 *       type delay;
 *     }
 *     container min-max-delay {
 *       leaf min-delay {
 *         type delay;
 *       }
 *       leaf max-delay {
 *         type delay;
 *       }
 *     }
 *     leaf jitter {
 *       type delay;
 *     }
 *     leaf loss {
 *       type loss;
 *     }
 *     leaf residual-bandwidth {
 *       type decimal-bandwidth;
 *     }
 *     leaf available-bandwidth {
 *       type decimal-bandwidth;
 *     }
 *     leaf utilized-bandwidth {
 *       type decimal-bandwidth;
 *     }
 *     leaf adj-sid {
 *       units "MPLS label";
 *       type uint32;
 *     }
 *     leaf backup-adj-sid {
 *       units "MPLS label";
 *       type uint32;
 *     }
 *     leaf-list srlgs {
 *       type uint32;
 *     }
 *   }
 *   grouping edge {
 *     leaf edge-id {
 *       type uint64;
 *     }
 *     leaf local-vertex-id {
 *       type uint64;
 *     }
 *     leaf remote-vertex-id {
 *       type uint64;
 *     }
 *     leaf name {
 *       type string;
 *     }
 *     container edge-attributes {
 *       uses edge-attributes;
 *     }
 *   }
 *   grouping srgb {
 *     leaf lower-bound {
 *       type uint32;
 *     }
 *     leaf range-size {
 *       type uint32;
 *     }
 *   }
 *   grouping vertex {
 *     leaf vertex-id {
 *       type uint64;
 *     }
 *     leaf name {
 *       type string;
 *     }
 *     leaf router-id {
 *       type inet:ip-address;
 *     }
 *     leaf vertex-type {
 *       type enumeration {
 *         enum standard {
 *           value 0;
 *         }
 *         enum abr {
 *           value 1;
 *         }
 *         enum asbr-in {
 *           value 2;
 *         }
 *         enum asbr-out {
 *           value 3;
 *         }
 *         enum pseudo {
 *           value 4;
 *         }
 *       }
 *       default standard;
 *     }
 *     container srgb {
 *       uses srgb;
 *     }
 *     leaf asn {
 *       type uint32;
 *     }
 *   }
 *   grouping prefix {
 *     leaf prefix {
 *       type inet:ip-prefix;
 *     }
 *     leaf prefix-sid {
 *       type uint32;
 *     }
 *     leaf node-sid {
 *       type boolean;
 *     }
 *     leaf vertex-id {
 *       type uint64;
 *     }
 *   }
 *   container graph-topology {
 *     list graph {
 *       key name;
 *       leaf name {
 *         type string;
 *       }
 *       leaf domain-scope {
 *         type enumeration {
 *           enum intra-domain {
 *             value 1;
 *           }
 *           enum inter-domain {
 *             value 2;
 *           }
 *         }
 *         default intra-domain;
 *       }
 *       leaf asn {
 *         type uint32;
 *       }
 *       list vertex {
 *         key vertex-id;
 *         uses vertex;
 *       }
 *       list edge {
 *         key edge-id;
 *         uses edge;
 *       }
 *       list prefix {
 *         key prefix;
 *         uses prefix;
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
public interface GraphData
    extends
    DataRoot
{




    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.GraphTopology</code> <code>graphTopology</code>, or <code>null</code> if not present
     */
    @Nullable GraphTopology getGraphTopology();

}

