package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125;
import java.lang.Class;
import java.lang.Override;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.Graph;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.GraphKey;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>graph</b>
 * <pre>
 * container graph-topology {
 *   list graph {
 *     key name;
 *     leaf name {
 *       type string;
 *     }
 *     leaf domain-scope {
 *       type enumeration {
 *         enum intra-domain {
 *           value 1;
 *         }
 *         enum inter-domain {
 *           value 2;
 *         }
 *       }
 *       default intra-domain;
 *     }
 *     leaf asn {
 *       type uint32;
 *     }
 *     list vertex {
 *       key vertex-id;
 *       uses vertex;
 *     }
 *     list edge {
 *       key edge-id;
 *       uses edge;
 *     }
 *     list prefix {
 *       key prefix;
 *       uses prefix;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>graph/graph-topology</i>
 *
 * <p>To create instances of this class use {@link GraphTopologyBuilder}.
 * @see GraphTopologyBuilder
 *
 */
public interface GraphTopology
    extends
    ChildOf<GraphData>,
    Augmentable<GraphTopology>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("graph-topology");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.GraphTopology> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.GraphTopology.class;
    }
    
    /**
     * Graph representation of the Network Topology
     *
     *
     *
     * @return <code>java.util.Map</code> <code>graph</code>, or <code>null</code> if not present
     */
    @Nullable Map<GraphKey, Graph> getGraph();
    
    /**
     * @return <code>java.util.Map</code> <code>graph</code>, or an empty list if it is not present
     */
    default @NonNull Map<GraphKey, Graph> nonnullGraph() {
        return CodeHelpers.nonnull(getGraph());
    }

}

