package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125;
import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import javax.management.ConstructorParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.uint24.rev200104.Uint24;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Uint32;

public class Loss extends Uint24
 implements Serializable {
    private static final long serialVersionUID = 2545354480872784333L;
    public static final String _UNITS = "0.000003%";


    @ConstructorParameters("value")
    @ConstructorProperties("value")
    public Loss(Uint32 _value) {
        super(_value);
        
        CodeHelpers.requireValue(_value);
    
    }
    
    /**
     * Utility migration constructor.
     *
     * @param _value value in legacy Java type
     * @deprecated Use {#link Loss(Uint32)} instead.
     */
    @Deprecated(forRemoval = true)
    public Loss(Long _value) {
        this(CodeHelpers.compatUint(_value));
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public Loss(Loss source) {
        super(source);
    }
    /**
     * Creates a new instance from Uint24
     *
     * @param source Source object
     */
    public Loss(Uint24 source) {
        super(source);
    }

    public static Loss getDefaultInstance(final String defaultValue) {
        return new Loss(Uint32.valueOf(defaultValue));
    }





    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(Loss.class);
        CodeHelpers.appendValue(helper, "_UNITS", _UNITS);
        return helper.toString();
    }
}

