package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint64;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>graph</b>
 * <pre>
 * grouping prefix {
 *   leaf prefix {
 *     type inet:ip-prefix;
 *   }
 *   leaf prefix-sid {
 *     type uint32;
 *   }
 *   leaf node-sid {
 *     type boolean;
 *   }
 *   leaf vertex-id {
 *     type uint64;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>graph/prefix</i>
 *
 */
public interface Prefix
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("prefix");

    @Override
    Class<? extends Prefix> implementedInterface();
    
    /**
     * IP (v4 or v6) Prefix.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix</code> <code>prefix</code>, or <code>null</code> if not present
     */
    @Nullable IpPrefix getPrefix();
    
    /**
     * Segment Routing prefix Identifier. Unit MPLS label
     *
     *
     *
     * @return <code>org.opendaylight.yangtools.yang.common.Uint32</code> <code>prefixSid</code>, or <code>null</code> if not present
     */
    @Nullable Uint32 getPrefixSid();
    
    /**
     * Prefix is a Node Segment Routing Identifier (Node-SID)
     *
     *
     *
     * @return <code>java.lang.Boolean</code> <code>nodeSid</code>, or <code>null</code> if not present
     */
    @Nullable Boolean isNodeSid();
    
    /**
     * Reference to the Vertex where the prefix is attached
     *
     *
     *
     * @return <code>org.opendaylight.yangtools.yang.common.Uint64</code> <code>vertexId</code>, or <code>null</code> if not present
     */
    @Nullable Uint64 getVertexId();

}

