package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Segment Routing Global Block: lower-bound + range-size
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>graph</b>
 * <pre>
 * grouping srgb {
 *   leaf lower-bound {
 *     type uint32;
 *   }
 *   leaf range-size {
 *     type uint32;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>graph/srgb</i>
 *
 */
public interface Srgb
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("srgb");

    @Override
    Class<? extends Srgb> implementedInterface();
    
    /**
     * Lower bound of label range in SRGB. Unit MPLS label
     *
     *
     *
     * @return <code>org.opendaylight.yangtools.yang.common.Uint32</code> <code>lowerBound</code>, or <code>null</code> if not present
     */
    @Nullable Uint32 getLowerBound();
    
    /**
     * Label range size in SRGB. Unit MPLS label
     *
     *
     *
     * @return <code>org.opendaylight.yangtools.yang.common.Uint32</code> <code>rangeSize</code>, or <code>null</code> if not present
     */
    @Nullable Uint32 getRangeSize();

}

