package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Edge;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * All attributes associated to the Edge
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>graph</b>
 * <pre>
 * container edge-attributes {
 *   uses edge-attributes;
 * }
 * </pre>The schema path to identify an instance is
 * <i>graph/edge/edge-attributes</i>
 *
 * <p>To create instances of this class use {@link EdgeAttributesBuilder}.
 * @see EdgeAttributesBuilder
 *
 */
public interface EdgeAttributes
    extends
    ChildOf<Edge>,
    Augmentable<EdgeAttributes>,
    org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("edge-attributes");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.EdgeAttributes> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.EdgeAttributes.class;
    }

}

