package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Deprecated;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.DecimalBandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Delay;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Loss;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.attributes.MinMaxDelay;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.attributes.UnreservedBandwidth;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link EdgeAttributesBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     EdgeAttributesBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new EdgeAttributesBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of EdgeAttributesBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see EdgeAttributesBuilder
 * @see Builder
 *
 */
public class EdgeAttributesBuilder implements Builder<EdgeAttributes> {

    private Uint32 _adjSid;
    private Uint32 _adminGroup;
    private DecimalBandwidth _availableBandwidth;
    private Uint32 _backupAdjSid;
    private Delay _delay;
    private Delay _jitter;
    private IpAddress _localAddress;
    private Uint32 _localIdentifier;
    private Loss _loss;
    private DecimalBandwidth _maxLinkBandwidth;
    private DecimalBandwidth _maxResvLinkBandwidth;
    private Uint32 _metric;
    private MinMaxDelay _minMaxDelay;
    private IpAddress _remoteAddress;
    private Uint32 _remoteIdentifier;
    private DecimalBandwidth _residualBandwidth;
    private List<Uint32> _srlgs;
    private Uint32 _teMetric;
    private List<UnreservedBandwidth> _unreservedBandwidth;
    private DecimalBandwidth _utilizedBandwidth;


    Map<Class<? extends Augmentation<EdgeAttributes>>, Augmentation<EdgeAttributes>> augmentation = Collections.emptyMap();

    public EdgeAttributesBuilder() {
    }
    public EdgeAttributesBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes arg) {
        this._metric = arg.getMetric();
        this._teMetric = arg.getTeMetric();
        this._adminGroup = arg.getAdminGroup();
        this._localAddress = arg.getLocalAddress();
        this._remoteAddress = arg.getRemoteAddress();
        this._localIdentifier = arg.getLocalIdentifier();
        this._remoteIdentifier = arg.getRemoteIdentifier();
        this._maxLinkBandwidth = arg.getMaxLinkBandwidth();
        this._maxResvLinkBandwidth = arg.getMaxResvLinkBandwidth();
        this._unreservedBandwidth = arg.getUnreservedBandwidth();
        this._delay = arg.getDelay();
        this._minMaxDelay = arg.getMinMaxDelay();
        this._jitter = arg.getJitter();
        this._loss = arg.getLoss();
        this._residualBandwidth = arg.getResidualBandwidth();
        this._availableBandwidth = arg.getAvailableBandwidth();
        this._utilizedBandwidth = arg.getUtilizedBandwidth();
        this._adjSid = arg.getAdjSid();
        this._backupAdjSid = arg.getBackupAdjSid();
        this._srlgs = arg.getSrlgs();
    }

    public EdgeAttributesBuilder(EdgeAttributes base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<EdgeAttributes>>, Augmentation<EdgeAttributes>> aug =((AugmentationHolder<EdgeAttributes>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._adjSid = base.getAdjSid();
        this._adminGroup = base.getAdminGroup();
        this._availableBandwidth = base.getAvailableBandwidth();
        this._backupAdjSid = base.getBackupAdjSid();
        this._delay = base.getDelay();
        this._jitter = base.getJitter();
        this._localAddress = base.getLocalAddress();
        this._localIdentifier = base.getLocalIdentifier();
        this._loss = base.getLoss();
        this._maxLinkBandwidth = base.getMaxLinkBandwidth();
        this._maxResvLinkBandwidth = base.getMaxResvLinkBandwidth();
        this._metric = base.getMetric();
        this._minMaxDelay = base.getMinMaxDelay();
        this._remoteAddress = base.getRemoteAddress();
        this._remoteIdentifier = base.getRemoteIdentifier();
        this._residualBandwidth = base.getResidualBandwidth();
        this._srlgs = base.getSrlgs();
        this._teMetric = base.getTeMetric();
        this._unreservedBandwidth = base.getUnreservedBandwidth();
        this._utilizedBandwidth = base.getUtilizedBandwidth();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes) {
            this._metric = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getMetric();
            this._teMetric = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getTeMetric();
            this._adminGroup = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getAdminGroup();
            this._localAddress = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getLocalAddress();
            this._remoteAddress = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getRemoteAddress();
            this._localIdentifier = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getLocalIdentifier();
            this._remoteIdentifier = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getRemoteIdentifier();
            this._maxLinkBandwidth = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getMaxLinkBandwidth();
            this._maxResvLinkBandwidth = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getMaxResvLinkBandwidth();
            this._unreservedBandwidth = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getUnreservedBandwidth();
            this._delay = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getDelay();
            this._minMaxDelay = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getMinMaxDelay();
            this._jitter = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getJitter();
            this._loss = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getLoss();
            this._residualBandwidth = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getResidualBandwidth();
            this._availableBandwidth = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getAvailableBandwidth();
            this._utilizedBandwidth = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getUtilizedBandwidth();
            this._adjSid = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getAdjSid();
            this._backupAdjSid = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getBackupAdjSid();
            this._srlgs = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes)arg).getSrlgs();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes]");
    }

    public Uint32 getAdjSid() {
        return _adjSid;
    }
    
    public Uint32 getAdminGroup() {
        return _adminGroup;
    }
    
    public DecimalBandwidth getAvailableBandwidth() {
        return _availableBandwidth;
    }
    
    public Uint32 getBackupAdjSid() {
        return _backupAdjSid;
    }
    
    public Delay getDelay() {
        return _delay;
    }
    
    public Delay getJitter() {
        return _jitter;
    }
    
    public IpAddress getLocalAddress() {
        return _localAddress;
    }
    
    public Uint32 getLocalIdentifier() {
        return _localIdentifier;
    }
    
    public Loss getLoss() {
        return _loss;
    }
    
    public DecimalBandwidth getMaxLinkBandwidth() {
        return _maxLinkBandwidth;
    }
    
    public DecimalBandwidth getMaxResvLinkBandwidth() {
        return _maxResvLinkBandwidth;
    }
    
    public Uint32 getMetric() {
        return _metric;
    }
    
    public MinMaxDelay getMinMaxDelay() {
        return _minMaxDelay;
    }
    
    public IpAddress getRemoteAddress() {
        return _remoteAddress;
    }
    
    public Uint32 getRemoteIdentifier() {
        return _remoteIdentifier;
    }
    
    public DecimalBandwidth getResidualBandwidth() {
        return _residualBandwidth;
    }
    
    public List<Uint32> getSrlgs() {
        return _srlgs;
    }
    
    public Uint32 getTeMetric() {
        return _teMetric;
    }
    
    public List<UnreservedBandwidth> getUnreservedBandwidth() {
        return _unreservedBandwidth;
    }
    
    public DecimalBandwidth getUtilizedBandwidth() {
        return _utilizedBandwidth;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<EdgeAttributes>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public EdgeAttributesBuilder setAdjSid(final Uint32 value) {
        this._adjSid = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setAdjSid(Uint32)} instead.
     */
    @Deprecated(forRemoval = true)
    public EdgeAttributesBuilder setAdjSid(final Long value) {
        return setAdjSid(CodeHelpers.compatUint(value));
    }
    
    public EdgeAttributesBuilder setAdminGroup(final Uint32 value) {
        this._adminGroup = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setAdminGroup(Uint32)} instead.
     */
    @Deprecated(forRemoval = true)
    public EdgeAttributesBuilder setAdminGroup(final Long value) {
        return setAdminGroup(CodeHelpers.compatUint(value));
    }
    
    public EdgeAttributesBuilder setAvailableBandwidth(final DecimalBandwidth value) {
        this._availableBandwidth = value;
        return this;
    }
    
    public EdgeAttributesBuilder setBackupAdjSid(final Uint32 value) {
        this._backupAdjSid = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setBackupAdjSid(Uint32)} instead.
     */
    @Deprecated(forRemoval = true)
    public EdgeAttributesBuilder setBackupAdjSid(final Long value) {
        return setBackupAdjSid(CodeHelpers.compatUint(value));
    }
    
    public EdgeAttributesBuilder setDelay(final Delay value) {
        this._delay = value;
        return this;
    }
    
    public EdgeAttributesBuilder setJitter(final Delay value) {
        this._jitter = value;
        return this;
    }
    
    public EdgeAttributesBuilder setLocalAddress(final IpAddress value) {
        this._localAddress = value;
        return this;
    }
    
    public EdgeAttributesBuilder setLocalIdentifier(final Uint32 value) {
        this._localIdentifier = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setLocalIdentifier(Uint32)} instead.
     */
    @Deprecated(forRemoval = true)
    public EdgeAttributesBuilder setLocalIdentifier(final Long value) {
        return setLocalIdentifier(CodeHelpers.compatUint(value));
    }
    
    public EdgeAttributesBuilder setLoss(final Loss value) {
        this._loss = value;
        return this;
    }
    
    public EdgeAttributesBuilder setMaxLinkBandwidth(final DecimalBandwidth value) {
        this._maxLinkBandwidth = value;
        return this;
    }
    
    public EdgeAttributesBuilder setMaxResvLinkBandwidth(final DecimalBandwidth value) {
        this._maxResvLinkBandwidth = value;
        return this;
    }
    
    public EdgeAttributesBuilder setMetric(final Uint32 value) {
        this._metric = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setMetric(Uint32)} instead.
     */
    @Deprecated(forRemoval = true)
    public EdgeAttributesBuilder setMetric(final Long value) {
        return setMetric(CodeHelpers.compatUint(value));
    }
    
    public EdgeAttributesBuilder setMinMaxDelay(final MinMaxDelay value) {
        this._minMaxDelay = value;
        return this;
    }
    
    public EdgeAttributesBuilder setRemoteAddress(final IpAddress value) {
        this._remoteAddress = value;
        return this;
    }
    
    public EdgeAttributesBuilder setRemoteIdentifier(final Uint32 value) {
        this._remoteIdentifier = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setRemoteIdentifier(Uint32)} instead.
     */
    @Deprecated(forRemoval = true)
    public EdgeAttributesBuilder setRemoteIdentifier(final Long value) {
        return setRemoteIdentifier(CodeHelpers.compatUint(value));
    }
    
    public EdgeAttributesBuilder setResidualBandwidth(final DecimalBandwidth value) {
        this._residualBandwidth = value;
        return this;
    }
    public EdgeAttributesBuilder setSrlgs(final List<Uint32> values) {
        this._srlgs = values;
        return this;
    }
    
    
    public EdgeAttributesBuilder setTeMetric(final Uint32 value) {
        this._teMetric = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setTeMetric(Uint32)} instead.
     */
    @Deprecated(forRemoval = true)
    public EdgeAttributesBuilder setTeMetric(final Long value) {
        return setTeMetric(CodeHelpers.compatUint(value));
    }
    public EdgeAttributesBuilder setUnreservedBandwidth(final List<UnreservedBandwidth> values) {
        this._unreservedBandwidth = values;
        return this;
    }
    
    
    public EdgeAttributesBuilder setUtilizedBandwidth(final DecimalBandwidth value) {
        this._utilizedBandwidth = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public EdgeAttributesBuilder addAugmentation(Augmentation<EdgeAttributes> augmentation) {
        return doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }
    
    /**
      * Add or remove an augmentation to this builder's product.
      *
      * @param augmentationType augmentation type to be added or removed
      * @param augmentationValue augmentation value, null if the augmentation type should be removed
      * @return this builder
      * @deprecated Use either {@link #addAugmentation(Augmentation)} or {@link #removeAugmentation(Class)} instead.
      */
    @Deprecated(forRemoval = true)
    public EdgeAttributesBuilder addAugmentation(Class<? extends Augmentation<EdgeAttributes>> augmentationType, Augmentation<EdgeAttributes> augmentationValue) {
        return augmentationValue == null ? removeAugmentation(augmentationType) : doAddAugmentation(augmentationType, augmentationValue);
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public EdgeAttributesBuilder removeAugmentation(Class<? extends Augmentation<EdgeAttributes>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }
    
    private EdgeAttributesBuilder doAddAugmentation(Class<? extends Augmentation<EdgeAttributes>> augmentationType, Augmentation<EdgeAttributes> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    @Override
    public EdgeAttributes build() {
        return new EdgeAttributesImpl(this);
    }

    private static final class EdgeAttributesImpl
        extends AbstractAugmentable<EdgeAttributes>
        implements EdgeAttributes {
    
        private final Uint32 _adjSid;
        private final Uint32 _adminGroup;
        private final DecimalBandwidth _availableBandwidth;
        private final Uint32 _backupAdjSid;
        private final Delay _delay;
        private final Delay _jitter;
        private final IpAddress _localAddress;
        private final Uint32 _localIdentifier;
        private final Loss _loss;
        private final DecimalBandwidth _maxLinkBandwidth;
        private final DecimalBandwidth _maxResvLinkBandwidth;
        private final Uint32 _metric;
        private final MinMaxDelay _minMaxDelay;
        private final IpAddress _remoteAddress;
        private final Uint32 _remoteIdentifier;
        private final DecimalBandwidth _residualBandwidth;
        private final List<Uint32> _srlgs;
        private final Uint32 _teMetric;
        private final List<UnreservedBandwidth> _unreservedBandwidth;
        private final DecimalBandwidth _utilizedBandwidth;
    
        EdgeAttributesImpl(EdgeAttributesBuilder base) {
            super(base.augmentation);
            this._adjSid = base.getAdjSid();
            this._adminGroup = base.getAdminGroup();
            this._availableBandwidth = base.getAvailableBandwidth();
            this._backupAdjSid = base.getBackupAdjSid();
            this._delay = base.getDelay();
            this._jitter = base.getJitter();
            this._localAddress = base.getLocalAddress();
            this._localIdentifier = base.getLocalIdentifier();
            this._loss = base.getLoss();
            this._maxLinkBandwidth = base.getMaxLinkBandwidth();
            this._maxResvLinkBandwidth = base.getMaxResvLinkBandwidth();
            this._metric = base.getMetric();
            this._minMaxDelay = base.getMinMaxDelay();
            this._remoteAddress = base.getRemoteAddress();
            this._remoteIdentifier = base.getRemoteIdentifier();
            this._residualBandwidth = base.getResidualBandwidth();
            this._srlgs = base.getSrlgs();
            this._teMetric = base.getTeMetric();
            this._unreservedBandwidth = CodeHelpers.emptyToNull(base.getUnreservedBandwidth());
            this._utilizedBandwidth = base.getUtilizedBandwidth();
        }
    
        @Override
        public Uint32 getAdjSid() {
            return _adjSid;
        }
        
        @Override
        public Uint32 getAdminGroup() {
            return _adminGroup;
        }
        
        @Override
        public DecimalBandwidth getAvailableBandwidth() {
            return _availableBandwidth;
        }
        
        @Override
        public Uint32 getBackupAdjSid() {
            return _backupAdjSid;
        }
        
        @Override
        public Delay getDelay() {
            return _delay;
        }
        
        @Override
        public Delay getJitter() {
            return _jitter;
        }
        
        @Override
        public IpAddress getLocalAddress() {
            return _localAddress;
        }
        
        @Override
        public Uint32 getLocalIdentifier() {
            return _localIdentifier;
        }
        
        @Override
        public Loss getLoss() {
            return _loss;
        }
        
        @Override
        public DecimalBandwidth getMaxLinkBandwidth() {
            return _maxLinkBandwidth;
        }
        
        @Override
        public DecimalBandwidth getMaxResvLinkBandwidth() {
            return _maxResvLinkBandwidth;
        }
        
        @Override
        public Uint32 getMetric() {
            return _metric;
        }
        
        @Override
        public MinMaxDelay getMinMaxDelay() {
            return _minMaxDelay;
        }
        
        @Override
        public IpAddress getRemoteAddress() {
            return _remoteAddress;
        }
        
        @Override
        public Uint32 getRemoteIdentifier() {
            return _remoteIdentifier;
        }
        
        @Override
        public DecimalBandwidth getResidualBandwidth() {
            return _residualBandwidth;
        }
        
        @Override
        public List<Uint32> getSrlgs() {
            return _srlgs;
        }
        
        @Override
        public Uint32 getTeMetric() {
            return _teMetric;
        }
        
        @Override
        public List<UnreservedBandwidth> getUnreservedBandwidth() {
            return _unreservedBandwidth;
        }
        
        @Override
        public DecimalBandwidth getUtilizedBandwidth() {
            return _utilizedBandwidth;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_adjSid);
            result = prime * result + Objects.hashCode(_adminGroup);
            result = prime * result + Objects.hashCode(_availableBandwidth);
            result = prime * result + Objects.hashCode(_backupAdjSid);
            result = prime * result + Objects.hashCode(_delay);
            result = prime * result + Objects.hashCode(_jitter);
            result = prime * result + Objects.hashCode(_localAddress);
            result = prime * result + Objects.hashCode(_localIdentifier);
            result = prime * result + Objects.hashCode(_loss);
            result = prime * result + Objects.hashCode(_maxLinkBandwidth);
            result = prime * result + Objects.hashCode(_maxResvLinkBandwidth);
            result = prime * result + Objects.hashCode(_metric);
            result = prime * result + Objects.hashCode(_minMaxDelay);
            result = prime * result + Objects.hashCode(_remoteAddress);
            result = prime * result + Objects.hashCode(_remoteIdentifier);
            result = prime * result + Objects.hashCode(_residualBandwidth);
            result = prime * result + Objects.hashCode(_srlgs);
            result = prime * result + Objects.hashCode(_teMetric);
            result = prime * result + Objects.hashCode(_unreservedBandwidth);
            result = prime * result + Objects.hashCode(_utilizedBandwidth);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!EdgeAttributes.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            EdgeAttributes other = (EdgeAttributes)obj;
            if (!Objects.equals(_adjSid, other.getAdjSid())) {
                return false;
            }
            if (!Objects.equals(_adminGroup, other.getAdminGroup())) {
                return false;
            }
            if (!Objects.equals(_availableBandwidth, other.getAvailableBandwidth())) {
                return false;
            }
            if (!Objects.equals(_backupAdjSid, other.getBackupAdjSid())) {
                return false;
            }
            if (!Objects.equals(_delay, other.getDelay())) {
                return false;
            }
            if (!Objects.equals(_jitter, other.getJitter())) {
                return false;
            }
            if (!Objects.equals(_localAddress, other.getLocalAddress())) {
                return false;
            }
            if (!Objects.equals(_localIdentifier, other.getLocalIdentifier())) {
                return false;
            }
            if (!Objects.equals(_loss, other.getLoss())) {
                return false;
            }
            if (!Objects.equals(_maxLinkBandwidth, other.getMaxLinkBandwidth())) {
                return false;
            }
            if (!Objects.equals(_maxResvLinkBandwidth, other.getMaxResvLinkBandwidth())) {
                return false;
            }
            if (!Objects.equals(_metric, other.getMetric())) {
                return false;
            }
            if (!Objects.equals(_minMaxDelay, other.getMinMaxDelay())) {
                return false;
            }
            if (!Objects.equals(_remoteAddress, other.getRemoteAddress())) {
                return false;
            }
            if (!Objects.equals(_remoteIdentifier, other.getRemoteIdentifier())) {
                return false;
            }
            if (!Objects.equals(_residualBandwidth, other.getResidualBandwidth())) {
                return false;
            }
            if (!Objects.equals(_srlgs, other.getSrlgs())) {
                return false;
            }
            if (!Objects.equals(_teMetric, other.getTeMetric())) {
                return false;
            }
            if (!Objects.equals(_unreservedBandwidth, other.getUnreservedBandwidth())) {
                return false;
            }
            if (!Objects.equals(_utilizedBandwidth, other.getUtilizedBandwidth())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                EdgeAttributesImpl otherImpl = (EdgeAttributesImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<EdgeAttributes>>, Augmentation<EdgeAttributes>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("EdgeAttributes");
            CodeHelpers.appendValue(helper, "_adjSid", _adjSid);
            CodeHelpers.appendValue(helper, "_adminGroup", _adminGroup);
            CodeHelpers.appendValue(helper, "_availableBandwidth", _availableBandwidth);
            CodeHelpers.appendValue(helper, "_backupAdjSid", _backupAdjSid);
            CodeHelpers.appendValue(helper, "_delay", _delay);
            CodeHelpers.appendValue(helper, "_jitter", _jitter);
            CodeHelpers.appendValue(helper, "_localAddress", _localAddress);
            CodeHelpers.appendValue(helper, "_localIdentifier", _localIdentifier);
            CodeHelpers.appendValue(helper, "_loss", _loss);
            CodeHelpers.appendValue(helper, "_maxLinkBandwidth", _maxLinkBandwidth);
            CodeHelpers.appendValue(helper, "_maxResvLinkBandwidth", _maxResvLinkBandwidth);
            CodeHelpers.appendValue(helper, "_metric", _metric);
            CodeHelpers.appendValue(helper, "_minMaxDelay", _minMaxDelay);
            CodeHelpers.appendValue(helper, "_remoteAddress", _remoteAddress);
            CodeHelpers.appendValue(helper, "_remoteIdentifier", _remoteIdentifier);
            CodeHelpers.appendValue(helper, "_residualBandwidth", _residualBandwidth);
            CodeHelpers.appendValue(helper, "_srlgs", _srlgs);
            CodeHelpers.appendValue(helper, "_teMetric", _teMetric);
            CodeHelpers.appendValue(helper, "_unreservedBandwidth", _unreservedBandwidth);
            CodeHelpers.appendValue(helper, "_utilizedBandwidth", _utilizedBandwidth);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
