package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.attributes;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Delay;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Min/Max Unidirectional Delay
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>graph</b>
 * <pre>
 * container min-max-delay {
 *   leaf min-delay {
 *     type delay;
 *   }
 *   leaf max-delay {
 *     type delay;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>graph/edge-attributes/min-max-delay</i>
 *
 * <p>To create instances of this class use {@link MinMaxDelayBuilder}.
 * @see MinMaxDelayBuilder
 *
 */
public interface MinMaxDelay
    extends
    ChildOf<EdgeAttributes>,
    Augmentable<MinMaxDelay>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("min-max-delay");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.attributes.MinMaxDelay> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.attributes.MinMaxDelay.class;
    }
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Delay</code> <code>minDelay</code>, or <code>null</code> if not present
     */
    @Nullable Delay getMinDelay();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Delay</code> <code>maxDelay</code>, or <code>null</code> if not present
     */
    @Nullable Delay getMaxDelay();

}

