package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.attributes;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.DecimalBandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.EdgeAttributes;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Unreserved bandwidth for 0-7 class type
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>graph</b>
 * <pre>
 * list unreserved-bandwidth {
 *   max-elements 8;
 *   ordered-by user;
 *   key class-type;
 *   leaf class-type {
 *     type uint8 {
 *       range 0..7;
 *     }
 *   }
 *   leaf bandwidth {
 *     type decimal-bandwidth;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>graph/edge-attributes/unreserved-bandwidth</i>
 *
 * <p>To create instances of this class use {@link UnreservedBandwidthBuilder}.
 * @see UnreservedBandwidthBuilder
 * @see UnreservedBandwidthKey
 *
 */
public interface UnreservedBandwidth
    extends
    ChildOf<EdgeAttributes>,
    Augmentable<UnreservedBandwidth>,
    Identifiable<UnreservedBandwidthKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("unreserved-bandwidth");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.attributes.UnreservedBandwidth> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.attributes.UnreservedBandwidth.class;
    }
    
    /**
     * @return <code>org.opendaylight.yangtools.yang.common.Uint8</code> <code>classType</code>, or <code>null</code> if not present
     */
    @Nullable Uint8 getClassType();
    
    /**
     * Unreserved bandwidth for this class type
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.DecimalBandwidth</code> <code>bandwidth</code>, or <code>null</code> if not present
     */
    @Nullable DecimalBandwidth getBandwidth();
    
    @Override
    UnreservedBandwidthKey key();

}

