package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.edge.attributes;
import com.google.common.base.MoreObjects;
import java.lang.Override;
import java.lang.Short;
import java.lang.String;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.common.Uint8;

public class UnreservedBandwidthKey
 implements Identifier<UnreservedBandwidth> {
    private static final long serialVersionUID = -4666379233855102733L;
    private final Uint8 _classType;


    public UnreservedBandwidthKey(Uint8 _classType) {
    
        this._classType = _classType;
    }
    
    /**
     * Utility migration constructor.
     *
     * @param _classType classType in legacy Java type
     * @deprecated Use {#link UnreservedBandwidthKey(Uint8)} instead.
     */
    @Deprecated(forRemoval = true)
    public UnreservedBandwidthKey(Short _classType) {
        this(CodeHelpers.compatUint(_classType));
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public UnreservedBandwidthKey(UnreservedBandwidthKey source) {
        this._classType = source._classType;
    }


    public Uint8 getClassType() {
        return _classType;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_classType);
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UnreservedBandwidthKey)) {
            return false;
        }
        final UnreservedBandwidthKey other = (UnreservedBandwidthKey) obj;
        if (!Objects.equals(_classType, other._classType)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(UnreservedBandwidthKey.class);
        CodeHelpers.appendValue(helper, "_classType", _classType);
        return helper.toString();
    }
}

