package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.GraphTopology;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.Edge;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.EdgeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.Prefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.PrefixKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.Vertex;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.VertexKey;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Graph representation of the Network Topology
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>graph</b>
 * <pre>
 * list graph {
 *   key name;
 *   leaf name {
 *     type string;
 *   }
 *   leaf domain-scope {
 *     type enumeration {
 *       enum intra-domain {
 *         value 1;
 *       }
 *       enum inter-domain {
 *         value 2;
 *       }
 *     }
 *     default intra-domain;
 *   }
 *   leaf asn {
 *     type uint32;
 *   }
 *   list vertex {
 *     key vertex-id;
 *     uses vertex;
 *   }
 *   list edge {
 *     key edge-id;
 *     uses edge;
 *   }
 *   list prefix {
 *     key prefix;
 *     uses prefix;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>graph/graph-topology/graph</i>
 *
 * <p>To create instances of this class use {@link GraphBuilder}.
 * @see GraphBuilder
 * @see GraphKey
 *
 */
public interface Graph
    extends
    ChildOf<GraphTopology>,
    Augmentable<Graph>,
    Identifiable<GraphKey>
{


    public enum DomainScope implements Enumeration {
        IntraDomain(1, "intra-domain"),
        
        InterDomain(2, "inter-domain")
        ;
    
        private static final Map<String, DomainScope> NAME_MAP;
        private static final Map<Integer, DomainScope> VALUE_MAP;
    
        static {
            final Builder<String, DomainScope> nb = ImmutableMap.builder();
            final Builder<Integer, DomainScope> vb = ImmutableMap.builder();
            for (DomainScope enumItem : DomainScope.values()) {
                vb.put(enumItem.value, enumItem);
                nb.put(enumItem.name, enumItem);
            }
    
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    
        private final String name;
        private final int value;
    
        private DomainScope(int value, String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified value.
         *
         * @param name YANG assigned name
         * @return corresponding DomainScope item, if present
         * @throws NullPointerException if name is null
         */
        public static Optional<DomainScope> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding DomainScope item, or null if no such item exists
         */
        public static DomainScope forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }
    }

    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("graph");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.Graph> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.Graph.class;
    }
    
    /**
     * @return <code>java.lang.String</code> <code>name</code>, or <code>null</code> if not present
     */
    @Nullable String getName();
    
    /**
     * Network domain scope: intra or inter domain
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.Graph.DomainScope</code> <code>domainScope</code>, or <code>null</code> if not present
     */
    @Nullable DomainScope getDomainScope();
    
    /**
     * AS Number
     *
     *
     *
     * @return <code>org.opendaylight.yangtools.yang.common.Uint32</code> <code>asn</code>, or <code>null</code> if not present
     */
    @Nullable Uint32 getAsn();
    
    /**
     * The list of Vertices defined for the Graph.
     *
     *
     *
     * @return <code>java.util.Map</code> <code>vertex</code>, or <code>null</code> if not present
     */
    @Nullable Map<VertexKey, Vertex> getVertex();
    
    /**
     * @return <code>java.util.Map</code> <code>vertex</code>, or an empty list if it is not present
     */
    default @NonNull Map<VertexKey, Vertex> nonnullVertex() {
        return CodeHelpers.nonnull(getVertex());
    }
    
    /**
     * The list of Edges defined for the Graph.
     *
     *
     *
     * @return <code>java.util.Map</code> <code>edge</code>, or <code>null</code> if not present
     */
    @Nullable Map<EdgeKey, Edge> getEdge();
    
    /**
     * @return <code>java.util.Map</code> <code>edge</code>, or an empty list if it is not present
     */
    default @NonNull Map<EdgeKey, Edge> nonnullEdge() {
        return CodeHelpers.nonnull(getEdge());
    }
    
    /**
     * The list of prefixes for the Graph.
     *
     *
     *
     * @return <code>java.util.Map</code> <code>prefix</code>, or <code>null</code> if not present
     */
    @Nullable Map<PrefixKey, Prefix> getPrefix();
    
    /**
     * @return <code>java.util.Map</code> <code>prefix</code>, or an empty list if it is not present
     */
    default @NonNull Map<PrefixKey, Prefix> nonnullPrefix() {
        return CodeHelpers.nonnull(getPrefix());
    }
    
    @Override
    GraphKey key();

}

