package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.Graph;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * The list of Edges defined for the Graph.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>graph</b>
 * <pre>
 * list edge {
 *   key edge-id;
 *   uses edge;
 * }
 * </pre>The schema path to identify an instance is
 * <i>graph/graph-topology/graph/edge</i>
 *
 * <p>To create instances of this class use {@link EdgeBuilder}.
 * @see EdgeBuilder
 * @see EdgeKey
 *
 */
public interface Edge
    extends
    ChildOf<Graph>,
    Augmentable<Edge>,
    org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Edge,
    Identifiable<EdgeKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("edge");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.Edge> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.Edge.class;
    }
    
    @Override
    EdgeKey key();

}

