package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph;
import com.google.common.base.MoreObjects;
import java.lang.Override;
import java.lang.String;
import java.math.BigInteger;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.common.Uint64;

public class EdgeKey
 implements Identifier<Edge> {
    private static final long serialVersionUID = 441729458803676756L;
    private final Uint64 _edgeId;


    public EdgeKey(Uint64 _edgeId) {
    
        this._edgeId = _edgeId;
    }
    
    /**
     * Utility migration constructor.
     *
     * @param _edgeId edgeId in legacy Java type
     * @deprecated Use {#link EdgeKey(Uint64)} instead.
     */
    @Deprecated(forRemoval = true)
    public EdgeKey(BigInteger _edgeId) {
        this(CodeHelpers.compatUint(_edgeId));
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public EdgeKey(EdgeKey source) {
        this._edgeId = source._edgeId;
    }


    public Uint64 getEdgeId() {
        return _edgeId;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_edgeId);
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EdgeKey)) {
            return false;
        }
        final EdgeKey other = (EdgeKey) obj;
        if (!Objects.equals(_edgeId, other._edgeId)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(EdgeKey.class);
        CodeHelpers.appendValue(helper, "_edgeId", _edgeId);
        return helper.toString();
    }
}

