package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Deprecated;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint64;

/**
 * Class that builds {@link PrefixBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     PrefixBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new PrefixBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of PrefixBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see PrefixBuilder
 * @see Builder
 *
 */
public class PrefixBuilder implements Builder<Prefix> {

    private IpPrefix _prefix;
    private Uint32 _prefixSid;
    private Uint64 _vertexId;
    private Boolean _nodeSid;
    private PrefixKey key;


    Map<Class<? extends Augmentation<Prefix>>, Augmentation<Prefix>> augmentation = Collections.emptyMap();

    public PrefixBuilder() {
    }
    public PrefixBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Prefix arg) {
        this._prefix = arg.getPrefix();
        this._prefixSid = arg.getPrefixSid();
        this._nodeSid = arg.isNodeSid();
        this._vertexId = arg.getVertexId();
    }

    public PrefixBuilder(Prefix base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<Prefix>>, Augmentation<Prefix>> aug =((AugmentationHolder<Prefix>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this.key = base.key();
        this._prefix = base.getPrefix();
        this._prefixSid = base.getPrefixSid();
        this._vertexId = base.getVertexId();
        this._nodeSid = base.isNodeSid();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Prefix</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Prefix) {
            this._prefix = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Prefix)arg).getPrefix();
            this._prefixSid = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Prefix)arg).getPrefixSid();
            this._nodeSid = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Prefix)arg).isNodeSid();
            this._vertexId = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Prefix)arg).getVertexId();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Prefix]");
    }

    public PrefixKey key() {
        return key;
    }
    
    public IpPrefix getPrefix() {
        return _prefix;
    }
    
    public Uint32 getPrefixSid() {
        return _prefixSid;
    }
    
    public Uint64 getVertexId() {
        return _vertexId;
    }
    
    public Boolean isNodeSid() {
        return _nodeSid;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Prefix>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public PrefixBuilder withKey(final PrefixKey key) {
        this.key = key;
        return this;
    }
    
    public PrefixBuilder setPrefix(final IpPrefix value) {
        this._prefix = value;
        return this;
    }
    
    public PrefixBuilder setPrefixSid(final Uint32 value) {
        this._prefixSid = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setPrefixSid(Uint32)} instead.
     */
    @Deprecated(forRemoval = true)
    public PrefixBuilder setPrefixSid(final Long value) {
        return setPrefixSid(CodeHelpers.compatUint(value));
    }
    
    public PrefixBuilder setVertexId(final Uint64 value) {
        this._vertexId = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setVertexId(Uint64)} instead.
     */
    @Deprecated(forRemoval = true)
    public PrefixBuilder setVertexId(final BigInteger value) {
        return setVertexId(CodeHelpers.compatUint(value));
    }
    
    public PrefixBuilder setNodeSid(final Boolean value) {
        this._nodeSid = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public PrefixBuilder addAugmentation(Augmentation<Prefix> augmentation) {
        return doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }
    
    /**
      * Add or remove an augmentation to this builder's product.
      *
      * @param augmentationType augmentation type to be added or removed
      * @param augmentationValue augmentation value, null if the augmentation type should be removed
      * @return this builder
      * @deprecated Use either {@link #addAugmentation(Augmentation)} or {@link #removeAugmentation(Class)} instead.
      */
    @Deprecated(forRemoval = true)
    public PrefixBuilder addAugmentation(Class<? extends Augmentation<Prefix>> augmentationType, Augmentation<Prefix> augmentationValue) {
        return augmentationValue == null ? removeAugmentation(augmentationType) : doAddAugmentation(augmentationType, augmentationValue);
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public PrefixBuilder removeAugmentation(Class<? extends Augmentation<Prefix>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }
    
    private PrefixBuilder doAddAugmentation(Class<? extends Augmentation<Prefix>> augmentationType, Augmentation<Prefix> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    @Override
    public Prefix build() {
        return new PrefixImpl(this);
    }

    private static final class PrefixImpl
        extends AbstractAugmentable<Prefix>
        implements Prefix {
    
        private final IpPrefix _prefix;
        private final Uint32 _prefixSid;
        private final Uint64 _vertexId;
        private final Boolean _nodeSid;
        private final PrefixKey key;
    
        PrefixImpl(PrefixBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new PrefixKey(base.getPrefix());
            }
            this._prefix = key.getPrefix();
            this._prefixSid = base.getPrefixSid();
            this._vertexId = base.getVertexId();
            this._nodeSid = base.isNodeSid();
        }
    
        @Override
        public PrefixKey key() {
            return key;
        }
        
        @Override
        public IpPrefix getPrefix() {
            return _prefix;
        }
        
        @Override
        public Uint32 getPrefixSid() {
            return _prefixSid;
        }
        
        @Override
        public Uint64 getVertexId() {
            return _vertexId;
        }
        
        @Override
        public Boolean isNodeSid() {
            return _nodeSid;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_prefix);
            result = prime * result + Objects.hashCode(_prefixSid);
            result = prime * result + Objects.hashCode(_vertexId);
            result = prime * result + Objects.hashCode(_nodeSid);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Prefix.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            Prefix other = (Prefix)obj;
            if (!Objects.equals(_prefix, other.getPrefix())) {
                return false;
            }
            if (!Objects.equals(_prefixSid, other.getPrefixSid())) {
                return false;
            }
            if (!Objects.equals(_vertexId, other.getVertexId())) {
                return false;
            }
            if (!Objects.equals(_nodeSid, other.isNodeSid())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                PrefixImpl otherImpl = (PrefixImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<Prefix>>, Augmentation<Prefix>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Prefix");
            CodeHelpers.appendValue(helper, "_prefix", _prefix);
            CodeHelpers.appendValue(helper, "_prefixSid", _prefixSid);
            CodeHelpers.appendValue(helper, "_vertexId", _vertexId);
            CodeHelpers.appendValue(helper, "_nodeSid", _nodeSid);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
