package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph;
import com.google.common.base.MoreObjects;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

public class PrefixKey
 implements Identifier<Prefix> {
    private static final long serialVersionUID = 6237631375778515810L;
    private final IpPrefix _prefix;


    public PrefixKey(IpPrefix _prefix) {
    
        this._prefix = _prefix;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public PrefixKey(PrefixKey source) {
        this._prefix = source._prefix;
    }


    public IpPrefix getPrefix() {
        return _prefix;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_prefix);
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PrefixKey)) {
            return false;
        }
        final PrefixKey other = (PrefixKey) obj;
        if (!Objects.equals(_prefix, other._prefix)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(PrefixKey.class);
        CodeHelpers.appendValue(helper, "_prefix", _prefix);
        return helper.toString();
    }
}

