package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.Graph;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * The list of Vertices defined for the Graph.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>graph</b>
 * <pre>
 * list vertex {
 *   key vertex-id;
 *   uses vertex;
 * }
 * </pre>The schema path to identify an instance is
 * <i>graph/graph-topology/graph/vertex</i>
 *
 * <p>To create instances of this class use {@link VertexBuilder}.
 * @see VertexBuilder
 * @see VertexKey
 *
 */
public interface Vertex
    extends
    ChildOf<Graph>,
    Augmentable<Vertex>,
    org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Vertex,
    Identifiable<VertexKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("vertex");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.Vertex> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.Vertex.class;
    }
    
    @Override
    VertexKey key();

}

