package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.vertex;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Deprecated;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link SrgbBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     SrgbBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new SrgbBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of SrgbBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see SrgbBuilder
 * @see Builder
 *
 */
public class SrgbBuilder implements Builder<Srgb> {

    private Uint32 _lowerBound;
    private Uint32 _rangeSize;


    Map<Class<? extends Augmentation<Srgb>>, Augmentation<Srgb>> augmentation = Collections.emptyMap();

    public SrgbBuilder() {
    }
    public SrgbBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Srgb arg) {
        this._lowerBound = arg.getLowerBound();
        this._rangeSize = arg.getRangeSize();
    }

    public SrgbBuilder(Srgb base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<Srgb>>, Augmentation<Srgb>> aug =((AugmentationHolder<Srgb>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._lowerBound = base.getLowerBound();
        this._rangeSize = base.getRangeSize();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Srgb</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Srgb) {
            this._lowerBound = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Srgb)arg).getLowerBound();
            this._rangeSize = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Srgb)arg).getRangeSize();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Srgb]");
    }

    public Uint32 getLowerBound() {
        return _lowerBound;
    }
    
    public Uint32 getRangeSize() {
        return _rangeSize;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Srgb>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public SrgbBuilder setLowerBound(final Uint32 value) {
        this._lowerBound = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setLowerBound(Uint32)} instead.
     */
    @Deprecated(forRemoval = true)
    public SrgbBuilder setLowerBound(final Long value) {
        return setLowerBound(CodeHelpers.compatUint(value));
    }
    
    public SrgbBuilder setRangeSize(final Uint32 value) {
        this._rangeSize = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setRangeSize(Uint32)} instead.
     */
    @Deprecated(forRemoval = true)
    public SrgbBuilder setRangeSize(final Long value) {
        return setRangeSize(CodeHelpers.compatUint(value));
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public SrgbBuilder addAugmentation(Augmentation<Srgb> augmentation) {
        return doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }
    
    /**
      * Add or remove an augmentation to this builder's product.
      *
      * @param augmentationType augmentation type to be added or removed
      * @param augmentationValue augmentation value, null if the augmentation type should be removed
      * @return this builder
      * @deprecated Use either {@link #addAugmentation(Augmentation)} or {@link #removeAugmentation(Class)} instead.
      */
    @Deprecated(forRemoval = true)
    public SrgbBuilder addAugmentation(Class<? extends Augmentation<Srgb>> augmentationType, Augmentation<Srgb> augmentationValue) {
        return augmentationValue == null ? removeAugmentation(augmentationType) : doAddAugmentation(augmentationType, augmentationValue);
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public SrgbBuilder removeAugmentation(Class<? extends Augmentation<Srgb>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }
    
    private SrgbBuilder doAddAugmentation(Class<? extends Augmentation<Srgb>> augmentationType, Augmentation<Srgb> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    @Override
    public Srgb build() {
        return new SrgbImpl(this);
    }

    private static final class SrgbImpl
        extends AbstractAugmentable<Srgb>
        implements Srgb {
    
        private final Uint32 _lowerBound;
        private final Uint32 _rangeSize;
    
        SrgbImpl(SrgbBuilder base) {
            super(base.augmentation);
            this._lowerBound = base.getLowerBound();
            this._rangeSize = base.getRangeSize();
        }
    
        @Override
        public Uint32 getLowerBound() {
            return _lowerBound;
        }
        
        @Override
        public Uint32 getRangeSize() {
            return _rangeSize;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_lowerBound);
            result = prime * result + Objects.hashCode(_rangeSize);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Srgb.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            Srgb other = (Srgb)obj;
            if (!Objects.equals(_lowerBound, other.getLowerBound())) {
                return false;
            }
            if (!Objects.equals(_rangeSize, other.getRangeSize())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                SrgbImpl otherImpl = (SrgbImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<Srgb>>, Augmentation<Srgb>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Srgb");
            CodeHelpers.appendValue(helper, "_lowerBound", _lowerBound);
            CodeHelpers.appendValue(helper, "_rangeSize", _rangeSize);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
