/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Range;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.Objects;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;

public class DecimalBandwidth
implements ScalarTypeObject<BigDecimal>,
Serializable {
    private static final long serialVersionUID = 8069688163137208190L;
    public static final String _UNITS = "bytes/second";
    private final BigDecimal _value;
    private static final Range<BigDecimal>[] CHECK_VALUERANGE_RANGES;

    private static void check_valueRange(BigDecimal value) {
        for (Range<BigDecimal> r : CHECK_VALUERANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        CodeHelpers.throwInvalidRange((Object[])CHECK_VALUERANGE_RANGES, (Object)value);
    }

    @ConstructorParameters(value={"value"})
    @ConstructorProperties(value={"value"})
    public DecimalBandwidth(BigDecimal _value) {
        if (_value != null) {
            DecimalBandwidth.check_valueRange(_value);
        }
        CodeHelpers.requireValue((Object)_value);
        this._value = _value;
    }

    public DecimalBandwidth(DecimalBandwidth source) {
        this._value = source._value;
    }

    public static DecimalBandwidth getDefaultInstance(String defaultValue) {
        return new DecimalBandwidth(new BigDecimal(defaultValue));
    }

    public BigDecimal getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode((Object)this._value);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DecimalBandwidth)) {
            return false;
        }
        DecimalBandwidth other = (DecimalBandwidth)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(DecimalBandwidth.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_value", (Object)this._value);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_UNITS", (Object)_UNITS);
        return helper.toString();
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)new BigDecimal("-92233720368547758.08"), (Comparable)new BigDecimal("92233720368547758.07"));
        CHECK_VALUERANGE_RANGES = a;
    }
}

