/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.GraphTopology;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.Graph;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.GraphKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

public class GraphTopologyBuilder
implements Builder<GraphTopology> {
    private Map<GraphKey, Graph> _graph;
    Map<Class<? extends Augmentation<GraphTopology>>, Augmentation<GraphTopology>> augmentation = Collections.emptyMap();

    public GraphTopologyBuilder() {
    }

    public GraphTopologyBuilder(GraphTopology base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GraphTopology>>, Augmentation<GraphTopology>>(aug);
        }
        this._graph = base.getGraph();
    }

    public Map<GraphKey, Graph> getGraph() {
        return this._graph;
    }

    public <E$$ extends Augmentation<GraphTopology>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public GraphTopologyBuilder setGraph(Map<GraphKey, Graph> values) {
        this._graph = values;
        return this;
    }

    @Deprecated(forRemoval=true)
    public GraphTopologyBuilder setGraph(List<Graph> values) {
        return this.setGraph(CodeHelpers.compatMap(values));
    }

    public GraphTopologyBuilder addAugmentation(Augmentation<GraphTopology> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GraphTopology>>, Augmentation<GraphTopology>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public GraphTopologyBuilder removeAugmentation(Class<? extends Augmentation<GraphTopology>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public GraphTopology build() {
        return new GraphTopologyImpl(this);
    }

    private static final class GraphTopologyImpl
    extends AbstractAugmentable<GraphTopology>
    implements GraphTopology {
        private final Map<GraphKey, Graph> _graph;
        private int hash = 0;
        private volatile boolean hashValid = false;

        GraphTopologyImpl(GraphTopologyBuilder base) {
            super(base.augmentation);
            this._graph = CodeHelpers.emptyToNull(base.getGraph());
        }

        @Override
        public Map<GraphKey, Graph> getGraph() {
            return this._graph;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = GraphTopology.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return GraphTopology.bindingEquals(this, obj);
        }

        public String toString() {
            return GraphTopology.bindingToString(this);
        }
    }
}

