/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.Graph;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.GraphKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.Edge;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.EdgeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.Prefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.PrefixKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.Vertex;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.graph.VertexKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Uint32;

public class GraphBuilder
implements Builder<Graph> {
    private Uint32 _asn;
    private Graph.DomainScope _domainScope;
    private Map<EdgeKey, Edge> _edge;
    private String _name;
    private Map<PrefixKey, Prefix> _prefix;
    private Map<VertexKey, Vertex> _vertex;
    private GraphKey key;
    Map<Class<? extends Augmentation<Graph>>, Augmentation<Graph>> augmentation = Collections.emptyMap();

    public GraphBuilder() {
    }

    public GraphBuilder(Graph base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Graph>>, Augmentation<Graph>>(aug);
        }
        this.key = base.key();
        this._name = base.getName();
        this._asn = base.getAsn();
        this._domainScope = base.getDomainScope();
        this._edge = base.getEdge();
        this._prefix = base.getPrefix();
        this._vertex = base.getVertex();
    }

    public GraphKey key() {
        return this.key;
    }

    public Uint32 getAsn() {
        return this._asn;
    }

    public Graph.DomainScope getDomainScope() {
        return this._domainScope;
    }

    public Map<EdgeKey, Edge> getEdge() {
        return this._edge;
    }

    public String getName() {
        return this._name;
    }

    public Map<PrefixKey, Prefix> getPrefix() {
        return this._prefix;
    }

    public Map<VertexKey, Vertex> getVertex() {
        return this._vertex;
    }

    public <E$$ extends Augmentation<Graph>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public GraphBuilder withKey(GraphKey key) {
        this.key = key;
        return this;
    }

    public GraphBuilder setAsn(Uint32 value) {
        this._asn = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public GraphBuilder setAsn(Long value) {
        return this.setAsn(CodeHelpers.compatUint((Long)value));
    }

    public GraphBuilder setDomainScope(Graph.DomainScope value) {
        this._domainScope = value;
        return this;
    }

    public GraphBuilder setEdge(Map<EdgeKey, Edge> values) {
        this._edge = values;
        return this;
    }

    @Deprecated(forRemoval=true)
    public GraphBuilder setEdge(List<Edge> values) {
        return this.setEdge(CodeHelpers.compatMap(values));
    }

    public GraphBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public GraphBuilder setPrefix(Map<PrefixKey, Prefix> values) {
        this._prefix = values;
        return this;
    }

    @Deprecated(forRemoval=true)
    public GraphBuilder setPrefix(List<Prefix> values) {
        return this.setPrefix(CodeHelpers.compatMap(values));
    }

    public GraphBuilder setVertex(Map<VertexKey, Vertex> values) {
        this._vertex = values;
        return this;
    }

    @Deprecated(forRemoval=true)
    public GraphBuilder setVertex(List<Vertex> values) {
        return this.setVertex(CodeHelpers.compatMap(values));
    }

    public GraphBuilder addAugmentation(Augmentation<Graph> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Graph>>, Augmentation<Graph>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public GraphBuilder removeAugmentation(Class<? extends Augmentation<Graph>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Graph build() {
        return new GraphImpl(this);
    }

    private static final class GraphImpl
    extends AbstractAugmentable<Graph>
    implements Graph {
        private final Uint32 _asn;
        private final Graph.DomainScope _domainScope;
        private final Map<EdgeKey, Edge> _edge;
        private final String _name;
        private final Map<PrefixKey, Prefix> _prefix;
        private final Map<VertexKey, Vertex> _vertex;
        private final GraphKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        GraphImpl(GraphBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new GraphKey(base.getName());
            this._name = this.key.getName();
            this._asn = base.getAsn();
            this._domainScope = base.getDomainScope();
            this._edge = CodeHelpers.emptyToNull(base.getEdge());
            this._prefix = CodeHelpers.emptyToNull(base.getPrefix());
            this._vertex = CodeHelpers.emptyToNull(base.getVertex());
        }

        @Override
        public GraphKey key() {
            return this.key;
        }

        @Override
        public Uint32 getAsn() {
            return this._asn;
        }

        @Override
        public Graph.DomainScope getDomainScope() {
            return this._domainScope;
        }

        @Override
        public Map<EdgeKey, Edge> getEdge() {
            return this._edge;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public Map<PrefixKey, Prefix> getPrefix() {
            return this._prefix;
        }

        @Override
        public Map<VertexKey, Vertex> getVertex() {
            return this._vertex;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Graph.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Graph.bindingEquals(this, obj);
        }

        public String toString() {
            return Graph.bindingToString(this);
        }
    }
}

