package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.Graph;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.graph.topology.GraphKey;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

/**
 * Class that builds {@link GraphTopology} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     GraphTopology createGraphTopology(int fooXyzzy, int barBaz) {
 *         return new GraphTopologyBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of GraphTopology, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see GraphTopology
 *
 */
@Generated("mdsal-binding-generator")
public class GraphTopologyBuilder {

    private Map<GraphKey, Graph> _graph;


    Map<Class<? extends Augmentation<GraphTopology>>, Augmentation<GraphTopology>> augmentation = Collections.emptyMap();

    public GraphTopologyBuilder() {
    }
    
    

    public GraphTopologyBuilder(GraphTopology base) {
        Map<Class<? extends Augmentation<GraphTopology>>, Augmentation<GraphTopology>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._graph = base.getGraph();
    }


    public Map<GraphKey, Graph> getGraph() {
        return _graph;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<GraphTopology>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public GraphTopologyBuilder setGraph(final Map<GraphKey, Graph> values) {
        this._graph = values;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public GraphTopologyBuilder addAugmentation(Augmentation<GraphTopology> augmentation) {
        Class<? extends Augmentation<GraphTopology>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public GraphTopologyBuilder removeAugmentation(Class<? extends Augmentation<GraphTopology>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link GraphTopology} instance.
     *
     * @return A new {@link GraphTopology} instance.
     */
    public GraphTopology build() {
        return new GraphTopologyImpl(this);
    }

    private static final class GraphTopologyImpl
        extends AbstractAugmentable<GraphTopology>
        implements GraphTopology {
    
        private final Map<GraphKey, Graph> _graph;
    
        GraphTopologyImpl(GraphTopologyBuilder base) {
            super(base.augmentation);
            this._graph = CodeHelpers.emptyToNull(base.getGraph());
        }
    
        @Override
        public Map<GraphKey, Graph> getGraph() {
            return _graph;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = GraphTopology.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return GraphTopology.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return GraphTopology.bindingToString(this);
        }
    }
}
